# Nexus Admin Tracking - Sistema de Gestão Multi-Site

Este documento descreve a arquitetura, funcionalidades e estrutura de dados do sistema administrativo centralizado para gestão de sites de consulta e pagamentos.

## 1. Arquitetura do Sistema
O sistema segue o padrão **MVC (Model-View-Controller)** simplificado em PHP, focado em alta performance e escalabilidade para múltiplos domínios simultâneos.

- **Backend:** PHP 7.4+ (Core/Controllers/Middleware)
- **Banco de Dados:** MySQL/MariaDB (InnoDB)
- **Tracking:** JavaScript (Nexus Tracker) + API REST
- **Notificações:** Integração via Webhooks para WhatsApp e Telegram

## 2. Estrutura do Banco de Dados
O esquema foi projetado para unificar a jornada do usuário em um único registro, evitando redundância e facilitando a extração de métricas.

### Tabelas Principais:
- **`sites`**: Cadastro de domínios, chaves de API únicas e status de ativação.
- **`consultas`**: Tabela mestre que consolida o "Estado do Funil":
  - Dados do Veículo (Placa, Renavam, Modelo, Proprietário).
  - Financeiro (Valor total, Valor do DARJ, Status do Pagamento).
  - Identificação (IP, Visitor ID, User-Agent, WhatsApp capturado).
  - Timestamps de cada etapa (Visita, Consulta, Geração PIX, Pagamento).
- **`events`**: Log bruto de cada ação do usuário para auditoria detalhada.
- **`pix_config`**: Configuração individual de chaves PIX e recebedores por site.
- **`site_security_config`**: Regras de proteção (Anti-bot, bloqueio de DevTools, Rate Limit).
- **`daily_stats`**: Estatísticas pré-calculadas para carregamento rápido do dashboard.

## 3. Funcionalidades do Dashboard
O painel administrativo oferece controle granular sobre a operação:

### Monitoramento em Tempo Real
- **Dashboard Central:** Visão instantânea de Visitas, Consultas Realizadas, PIX Gerados e Valor Total Confirmado no dia.
- **Filtros de Funil:** Visualização segmentada de usuários em cada etapa da conversão.
- **Geolocalização:** Identificação automática de cidade, estado e provedor de internet do visitante.

### Gestão e Configuração
- **Gestão de PIX:** Interface para definir chaves PIX (criptografadas) e nomes de recebedores personalizados por site.
- **Controle de Acesso:** Gestão de usuários com níveis de permissão (Super Admin, Admin, Viewer).
- **Confirmação Manual:** Possibilidade de aprovar pagamentos manualmente em casos de exceção.

### Segurança Avançada
- **Anti-Bot & Anti-Spy:** Detecção de bots e bloqueio de ferramentas de inspeção de código (F12).
- **Blacklist de IP:** Bloqueio manual ou automático de endereços suspeitos.
- **Rate Limiting:** Controle de requisições por minuto para evitar ataques de força bruta.

## 4. Sistema de Notificações
O sistema envia relatórios detalhados para o WhatsApp/Telegram do administrador:
- **Relatório de Consulta:** Quando uma placa é pesquisada, envia os dados do veículo + extrato de débitos + contato do cliente.
- **Status de Pagamento:** Notificação imediata quando um PIX é gerado ou confirmado.
- **Alertas de Segurança:** Avisos sobre tentativas de bypass ou acessos de IPs bloqueados.

## 5. Lógica de Conversão (Funil)
O sistema opera seguindo o ciclo de vida:
1. **Visit (`visit`)**: Captura inicial de IP e dispositivo.
2. **Search (`consulta_placa`)**: Registro de placa/renavam e disparo da primeira notificação.
3. **Payment (`pix_gerado`)**: Geração do código PIX e atualização do status financeiro.
4. **Completion (`pix_confirmado`)**: Confirmação do pagamento e finalização do atendimento.

---
*Documentação gerada automaticamente para fins de análise técnica do sistema.*

## 6. Sugestões de Aprimoramento e Correções

### Correções de Erros e Estabilidade
- **Notificações Assíncronas:** Migrar o envio de mensagens para segundo plano para não impactar a velocidade do site.
- **Tratamento de Erros:** Substituir blocos `catch` vazios por logs detalhados para facilitar diagnósticos.
- **Validação de IP:** Reforçar a detecção de IP contra spoofing, validando a origem (Cloudflare/Proxy).
- **Prevenção de Perda de Dados:** Substituir `TRUNCATE TABLE` por exclusão lógica ou confirmação de segurança.

### Melhorias de Segurança
- **Proteção CSRF:** Adicionar tokens de segurança nas rotas administrativas.
- **Criptografia End-to-End:** Garantir que chaves PIX sensíveis nunca sejam tratadas como texto simples no código.
- **Auditoria Completa:** Registrar logs de todas as alterações críticas feitas por administradores.

### Performance e Escalabilidade
- **Otimização de Queries:** Substituir subqueries no dashboard por agregações na tabela `daily_stats`.
- **Retenção de Dados:** Implementar rotina de limpeza automática para logs brutos antigos (tabela `events`).

### Novas Funcionalidades
- **Exportação de Leads:** Download de contatos e placas em CSV/Excel.
- **Gráficos de Funil:** Visualização da taxa de conversão entre etapas.
- **Webhooks Externos:** Integração com outros sistemas para pós-venda.
