<?php
namespace Controllers;

use Core\Response;

class ApiKeyController
{
    private static $dbPath = '/var/www/api_placa/f7imr6zs30ovzazu/keys.db';

    public static function list()
    {
        if (!file_exists(self::$dbPath)) {
            Response::json(['status' => 'error', 'message' => 'Banco de dados da API não encontrado em ' . self::$dbPath], 404);
            return;
        }

        try {
            if (!in_array('sqlite', \PDO::getAvailableDrivers())) {
                throw new \Exception('Driver PDO SQLite não instalado no servidor.');
            }

            $pdo = new \PDO('sqlite:' . self::$dbPath);
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

            $stmt = $pdo->query('SELECT * FROM api_keys ORDER BY id DESC');
            $keys = $stmt->fetchAll(\PDO::FETCH_ASSOC);

            Response::json(['status' => 'success', 'data' => $keys]);
        }
        catch (\Exception $e) {
            $msg = 'Erro: ' . $e->getMessage();
            if (defined('DEBUG') && DEBUG) {
                $msg .= ' | No arquivo: ' . $e->getFile() . ':' . $e->getLine();
            }
            Response::json(['status' => 'error', 'message' => $msg], 500);
        }
    }

    public static function create()
    {
        $owner = $_POST['identifier'] ?? $_POST['owner'] ?? 'Dashboard Generated';
        $expiresAt = $_POST['expires_at'] ?? date('Y-12-31');
        
        // Gerar valor da key
        $keyValue = 'sk_' . bin2hex(random_bytes(16));

        try {
            $pdo = new \PDO('sqlite:' . self::$dbPath);
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

            $stmt = $pdo->prepare('INSERT INTO api_keys (key_value, owner, expires_at, active) VALUES (?, ?, ?, 1)');
            $stmt->execute([$keyValue, $owner, $expiresAt]);

            Response::json(['status' => 'success', 'data' => ['key_value' => $keyValue], 'message' => 'Chave gerada com sucesso.']);
        }
        catch (\Exception $e) {
            Response::json(['status' => 'error', 'message' => $e->getMessage()], 500);
        }
    }

    public static function toggle()
    {
        $id = $_POST['id'] ?? null;
        if (!$id) {
            Response::json(['status' => 'error', 'message' => 'ID não fornecido.'], 400);
            return;
        }

        try {
            $pdo = new \PDO('sqlite:' . self::$dbPath);
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

            $stmt = $pdo->prepare('UPDATE api_keys SET active = CASE WHEN active = 1 THEN 0 ELSE 1 END WHERE id = :id');
            $stmt->execute([':id' => $id]);

            Response::json(['status' => 'success', 'message' => 'Status da chave atualizado.']);
        }
        catch (\Exception $e) {
            Response::json(['status' => 'error', 'message' => $e->getMessage()], 500);
        }
    }
}
