<?php
namespace Core;

class Notification {
    /**
     * Envia notificação imediatamente (Sincronamente)
     * @return bool Sucesso no envio
     */
    public static function send(string $message): bool {
        try {
            // Forçar JID solicitado pelo usuário
            $targetJid = "3298240006@s.whatsapp.net";
            
            // Buscar config para pegar o instance_id
            $pdo = \getDBConnection();
            $stmt = $pdo->prepare("SELECT setting_value FROM global_settings WHERE setting_key = 'whatsapp_config'");
            $stmt->execute();
            $waConfig = json_decode($stmt->fetchColumn() ?: '{}', true);

            self::sendWhatsApp($waConfig, $message, $targetJid);
            
            // Também salva na fila como log/backup se quiser, mas aqui enviamos direto
            $stmt = $pdo->prepare("INSERT INTO notification_queue (message, status) VALUES (?, 'sent')");
            $stmt->execute([$message]);
            
            return true;
        } catch (\Exception $e) {
            \error_log("Failed to send notification: " . $e->getMessage());
            return false;
        }
    }

    /**
     * Envio Real via API de WhatsApp
     */
    private static function sendWhatsApp(array $config, string $message, string $targetJid): void {
        $baseUrl = "http://191.252.214.221:3008/api/";
        $url = $baseUrl . "send"; 

        $payload = [
            'instanceId' => '3298240006', // Usando o JID/Número solicitado como ID da instância
            'jid' => $targetJid,
            'text' => $message
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: text/plain;charset=UTF-8']);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err) throw new \Exception($err);
    }
    
    // Mantendo para compatibilidade mas não usado no novo fluxo síncrono
    public static function processQueue(int $limit = 10): void { }
}
