<?php
/**
 * Script de Manutenção e Limpeza (Housekeeping)
 * Admin Server - NEXUS
 * 
 * Este script deve rodar uma vez por dia (via CRON).
 */

require_once __DIR__ . '/../config/database.php';

try {
    $pdo = getDBConnection();
    echo "Iniciando manutenção: " . date('Y-m-d H:i:s') . "
";

    // 1. Limpar eventos brutos com mais de 30 dias (Tabela pesada)
    $stmt1 = $pdo->prepare("DELETE FROM events WHERE created_at < DATE_SUB(NOW(), INTERVAL 30 DAY)");
    $stmt1->execute();
    echo "- Limpeza de eventos antigos: " . $stmt1->rowCount() . " linhas removidas.
";

    // 2. Limpar fila de notificações já enviadas com mais de 7 dias
    $stmt2 = $pdo->prepare("DELETE FROM notification_queue WHERE status = 'sent' AND created_at < DATE_SUB(NOW(), INTERVAL 7 DAY)");
    $stmt2->execute();
    echo "- Limpeza de notificações antigas: " . $stmt2->rowCount() . " linhas removidas.
";

    // 3. Limpar sessões expiradas
    $stmt3 = $pdo->prepare("DELETE FROM admin_sessions WHERE expires_at < NOW()");
    $stmt3->execute();
    echo "- Limpeza de sessões expiradas: " . $stmt3->rowCount() . " sessões removidas.
";

    // 4. Otimizar tabelas (opcional, recupera espaço em disco)
    $pdo->exec("OPTIMIZE TABLE events, notification_queue, consultas");
    echo "- Tabelas otimizadas com sucesso.
";

    echo "Manutenção finalizada: " . date('Y-m-d H:i:s') . "
";

} catch (Exception $e) {
    echo "ERRO NA MANUTENÇÃO: " . $e->getMessage() . "
";
    error_log("Maintenance Script Error: " . $e->getMessage());
}
