<?php
/**
 * Teste de INSERT em cada tabela
 */
header('Content-Type: text/plain');
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../config/database.php';

$pdo = getDBConnection();

echo "=== TESTE DE INSERTS ===\n\n";

// 1. Testar audit_logs
echo "1. audit_logs: ";
try {
    $stmt = $pdo->prepare("INSERT INTO audit_logs (action, site_id, details, ip_address) VALUES (?, ?, ?, ?)");
    $stmt->execute(['test', null, 'teste', '127.0.0.1']);
    echo "OK (id=" . $pdo->lastInsertId() . ")\n";
    $pdo->exec("DELETE FROM audit_logs WHERE action = 'test'");
} catch (Exception $e) {
    echo "ERRO: " . $e->getMessage() . "\n";
}

// 2. Testar sites
echo "2. sites: ";
try {
    $stmt = $pdo->prepare("INSERT INTO sites (name, domain, api_key, api_secret) VALUES (?, ?, ?, ?)");
    $stmt->execute(['teste', 'teste.com', 'sk_test123', 'secret123']);
    echo "OK (id=" . $pdo->lastInsertId() . ")\n";
    $pdo->exec("DELETE FROM sites WHERE name = 'teste'");
} catch (Exception $e) {
    echo "ERRO: " . $e->getMessage() . "\n";
}

// 3. Ver estrutura de audit_logs
echo "\n=== Estrutura audit_logs ===\n";
$stmt = $pdo->query("SHOW CREATE TABLE audit_logs");
$result = $stmt->fetch();
echo $result['Create Table'] . "\n";

// 4. Ver estrutura de sites
echo "\n=== Estrutura sites ===\n";
$stmt = $pdo->query("SHOW CREATE TABLE sites");
$result = $stmt->fetch();
echo $result['Create Table'] . "\n";
