<?php
session_start();
if (isset($_SESSION['admin_user'])) {
    header('Location: placeholder.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NEXUS SEARCH - Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Orbitron:wght@400;700&family=Inter:wght@300;400;600&display=swap');

        :root {
            --accent-cyan: #00e5ff;
            --accent-blue: #007bff;
            --accent-red: #ff3d00;
            --bg-dark: #05070a;
        }

        body {
            background-color: var(--bg-dark);
            color: #ffffff;
            font-family: 'Inter', sans-serif;
            margin: 0;
            overflow-x: hidden;
        }

        .font-orbitron { font-family: 'Orbitron', sans-serif; }

        #space-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
            background: radial-gradient(circle at 50% 50%, #0a192f 0%, #05070a 100%);
        }

        .star {
            position: absolute;
            background: white;
            border-radius: 50%;
            opacity: 0.3;
            animation: twinkle var(--d) infinite ease-in-out;
        }

        @keyframes twinkle {
            0%, 100% { opacity: 0.3; transform: scale(1); }
            50% { opacity: 1; transform: scale(1.3); }
        }
        
        .nav-scrolled {
            background-color: rgba(5, 7, 10, 0.8);
            backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 9999px;
            padding: 0.5rem 0;
            margin-top: 0;
            max-width: 80rem;
            margin-left: auto;
            margin-right: auto;
            box-shadow: 0 10px 30px rgba(0,0,0,0.5);
            width: 90% !important;
        }
        
        @media (min-width: 1024px) {
            .nav-scrolled {
                width: 100% !important;
                max-width: 1280px;
            }
        }

        .form-card-nexus {
            background: rgba(10, 16, 26, 0.8);
            backdrop-filter: blur(12px);
            border: 1px solid rgba(0, 229, 255, 0.2);
            border-radius: 24px;
            box-shadow: 0 0 40px rgba(0, 229, 255, 0.1);
        }

        .input-nexus {
            background: rgba(255, 255, 255, 0.05) !important;
            border: 1px solid rgba(255, 255, 255, 0.1) !important;
            color: white !important;
            transition: all 0.3s;
        }

        .input-nexus:focus {
            border-color: var(--accent-cyan) !important;
            box-shadow: 0 0 10px rgba(0, 229, 255, 0.2) !important;
            outline: none;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">

    <div id="space-bg"></div>

    <div class="fixed top-0 left-0 right-0 z-50 flex justify-center w-full transition-all duration-300 p-0" id="header-wrapper">
        <header id="main-header" class="transition-all duration-500 border-b nav-scrolled">
            <div class="w-full h-24 px-6 md:px-10 flex justify-between items-center max-w-7xl mx-auto">
                <div class="flex items-center">
                    <a href="/">
                        <img src="/logo.png" alt="NEXUS SEARCH" class="h-12 md:h-14 w-auto transition-transform hover:scale-105">
                    </a>
                </div>


                <div class="flex items-center gap-4 lg:hidden">
                    <button id="mobile-menu-btn" class="text-white text-2xl focus:outline-none p-2">
                        <i class="fas fa-bars"></i>
                    </button>
                </div>
            </div>

        </header>
    </div>

    <main class="flex-grow flex items-center justify-center pt-40 pb-12 px-6">
        <div class="w-full max-w-md">
            <form id="frm-login" action="login_action.php" method="POST" class="form-card-nexus p-8 md:p-10">
                <div class="text-center mb-10">
                    <h1 class="font-orbitron text-2xl font-bold mb-2">ACESSO RESTRITO</h1>
                    <div class="w-12 h-1 bg-cyan-500 mx-auto"></div>
                </div>

                <div class="space-y-6">
                    <div>
                        <label class="block text-xs uppercase tracking-widest text-gray-400 mb-2 font-bold">Usuário ou E-mail</label>
                        <input type="text" name="usuario" id="email" class="w-full px-4 py-3 rounded-xl input-nexus" required>
                    </div>
                    <div>
                        <label class="block text-xs uppercase tracking-widest text-gray-400 mb-2 font-bold">Senha</label>
                        <div class="relative">
                            <input type="password" id="password" name="senha" class="w-full px-4 py-3 rounded-xl input-nexus" required>
                        </div>
                    </div>
                    
                    <!-- Hidden field for captured IP -->
                    <input type="hidden" name="captured_ip" id="captured_ip">

                    <div class="flex items-center justify-between text-xs">
                        <label class="flex items-center gap-2 cursor-pointer text-gray-400">
                            <input type="checkbox" name="acceptTerms" checked required class="accent-cyan-500">
                            Aceito os <a href="/termos/" class="text-cyan-400 hover:underline">Termos</a>
                        </label>
                        <a href="reset_senha.php" class="text-cyan-400 hover:underline cursor-pointer">Esqueceu a senha?</a>
                    </div>

                    <button type="submit" id="btn-login" class="w-full bg-gradient-to-r from-blue-600 to-cyan-500 hover:from-blue-500 hover:to-cyan-400 text-white py-4 rounded-xl font-bold shadow-[0_0_20px_rgba(0,229,255,0.3)] transition-all transform hover:scale-[1.02]">
                        ENTRAR NO SISTEMA
                    </button>


                </div>
            </form>
        </div>
    </main>

    <footer class="py-8 border-t border-white/5 bg-black/50 backdrop-blur-md">
        <div class="max-w-7xl mx-auto px-6 flex flex-col md:flex-row justify-between items-center gap-6">
            <div class="flex flex-col items-center md:items-start gap-4 flex-grow">
                <div class="flex items-center gap-2">
                    <img src="/logo.png" alt="Logo" class="h-8 w-auto">
                </div>
                <p class="text-gray-600 text-xs tracking-widest uppercase text-center md:text-left">Segurança Cibernética &amp; Inteligência de Dados</p>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // IP Capture via ipify
        fetch('https://api.ipify.org?format=json')
            .then(r => r.json())
            .then(data => {
                document.getElementById('captured_ip').value = data.ip;
                console.log("IP Captured:", data.ip);
            })
            .catch(() => console.log("IP Capture Failed"));

        // Efeito de Estrelas
        const space = document.getElementById('space-bg');
        for (let i = 0; i < 100; i++) {
            const star = document.createElement('div');
            star.className = 'star';
            const x = Math.random() * 100;
            const y = Math.random() * 100;
            const size = Math.random() * 2 + 1;
            const duration = Math.random() * 3 + 2;
            star.style.left = `${x}%`;
            star.style.top = `${y}%`;
            star.style.width = `${size}px`;
            star.style.height = `${size}px`;
            star.style.setProperty('--d', `${duration}s`);
            space.appendChild(star);
        }

        const mobileBtn = document.getElementById('mobile-menu-btn');
        const mobileMenu = document.getElementById('mobile-menu');
        mobileBtn.addEventListener('click', () => { mobileMenu.classList.toggle('hidden'); });

        document.getElementById('frm-login').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            const btn = document.getElementById('btn-login');
            btn.innerHTML = 'VALIDANDO...';
            btn.disabled = true;

            fetch('api/admin.php?action=login', { 
                method: 'POST', 
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    username: formData.get('usuario'),
                    password: formData.get('senha')
                })
            })
            .then(r => r.json())
            .then(data => {
                if (data.status === 'success') {
                    window.location.href = 'placeholder.php';
                } else {
                    btn.innerHTML = 'ENTRAR NO SISTEMA';
                    btn.disabled = false;
                    Swal.fire({ icon: 'error', title: 'Erro', text: data.message || 'Credenciais inválidas', confirmButtonColor: '#00e5ff', background: '#0a101a', color: '#fff' });
                }
            })
            .catch(() => {
                btn.innerHTML = 'ENTRAR NO SISTEMA';
                btn.disabled = false;
                Swal.fire({ icon: 'error', title: 'Erro', text: 'Erro de comunicação.', confirmButtonColor: '#00e5ff', background: '#0a101a', color: '#fff' });
            });
        });
    </script>
</body>
</html>
