<?php
require_once '/var/www/admin-server/config/database.php';
session_start();

// Mock Auth::require()
function getMockData() {
    $pdo = getDBConnection();
    $pixEventTypes = "('pix_gerado', 'pix_generation_success', 'pix_generated', 'pix_iniciado')";
    $consultaEventTypes = "('cnpj_consulta', 'consulta', 'consulta_iniciada', 'consulta_placa')";
    $today = date('Y-m-d');

    $stmt = $pdo->query("
        SELECT 
            (SELECT COUNT(*) FROM sites WHERE is_active = 1) as total_sites,
            (SELECT COUNT(*) FROM admin_users) as total_users,
            COUNT(*) as events_today,
            COUNT(DISTINCT ip_address) as unique_ips_today,
            SUM(CASE WHEN event_type IN $consultaEventTypes THEN 1 ELSE 0 END) as consultas_today,
            SUM(CASE WHEN event_type IN $pixEventTypes THEN 1 ELSE 0 END) as pix_count_today,
            COALESCE(SUM(CASE WHEN event_type IN $pixEventTypes THEN valor ELSE 0 END), 0) as pix_value_today,
            SUM(CASE WHEN event_type = 'redirected' THEN 1 ELSE 0 END) as redirects_today,
            (SELECT COUNT(*) FROM events WHERE event_type = 'redirected') as total_redirects
        FROM events 
        WHERE created_at >= '$today 00:00:00'
    ");
    $summary = $stmt->fetch();
    
    echo json_encode([
        'summary' => $summary,
        'today' => $today,
        'now' => date('Y-m-d H:i:s')
    ], JSON_PRETTY_PRINT);
}

getMockData();
