const axios = require('axios');
const CryptoJS = require('crypto-js');

async function consultarZignetGO(placa) {
    console.log(`[Zignet GO] Consultando placa: ${placa}`);
    
    // Configurações extraídas do seu CURL
    const email = "rickcooder@gmail.com";
    const phone = "62996494518";
    const fingerprint = "t9vF262pEP0uG0oFnk5q"; // Vamos usar um fixo funcional por enquanto
    const terminal = "4068707027";

    const url = `https://nfbti53lkd.execute-api.us-east-2.amazonaws.com/dev/site/vehicle/${placa}?plate=${placa}&email=${email}&phone=${phone}&document=&renavam=&chassi=&uf=GO&skipDatacubeSearch=false&tpDebt=&fingerprintId=${fingerprint}`;

    try {
        const response = await axios.get(url, {
            headers: {
                "accept": "application/json, text/plain, */*",
                "terminal": terminal,
                "x-fingerprint-site-id": fingerprint,
                "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36",
                "origin": "https://www.zignet.com.br",
                "referer": "https://www.zignet.com.br/"
            }
        });

        const data = response.data;
        if (!data.vehicle) {
            return { success: false, error: "Veículo não encontrado" };
        }

        const encryptedRenavam = data.vehicle.renavam;
        console.log(`[Zignet GO] Renavam Criptografado: ${encryptedRenavam}`);

        // A Zignet usa uma técnica onde a chave é derivada de dados da sessão.
        // Se você tiver a 'numberKey' e 'dateIsoStringKey' da sessão atual, 
        // a descriptografia é feita assim (Simulação):
        // const renavam = decryptZignet(encryptedRenavam, sessionData);

        return {
            success: true,
            placa: data.vehicle.placa,
            renavam_encrypted: encryptedRenavam,
            vehicle_id: data.vehicle.id,
            uf: data.vehicle.uf
        };

    } catch (error) {
        console.error(`[Zignet GO] Erro: ${error.message}`);
        return { success: false, error: error.message };
    }
}

// Execução
const placa = process.argv[2];
if (!placa) {
    console.log("Uso: node zignet_go.js <PLACA>");
    process.exit(1);
}

consultarZignetGO(placa).then(res => console.log(JSON.stringify(res, null, 2)));
