const axios = require('axios');

async function getZignetSession() {
    console.log("[Zignet Init] Tentando obter nova sessão...");
    
    // Endpoint comum de inicialização/configuração
    const urlInit = "https://nfbti53lkd.execute-api.us-east-2.amazonaws.com/dev/site/config";
    const fingerprint = "t9vF262pEP0uG0oFnk5q";
    const terminal = "4068707027";

    try {
        const response = await axios.get(urlInit, {
            headers: {
                "terminal": terminal,
                "x-fingerprint-site-id": fingerprint,
                "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36",
                "origin": "https://www.zignet.com.br",
                "referer": "https://www.zignet.com.br/"
            }
        });

        // Procuramos no JSON retornado as chaves 'numberKey' e 'dateIsoStringKey'
        const data = response.data;
        console.log("[Zignet Init] Resposta de Configuração:", JSON.stringify(data, null, 2));

        return {
            success: true,
            data: data
        };

    } catch (error) {
        console.error(`[Zignet Init] Erro: ${error.message}`);
        return { success: false, error: error.message };
    }
}

getZignetSession().then(res => console.log(JSON.stringify(res, null, 2)));
