<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require_once __DIR__ . '/client-config.php';
require_once __DIR__ . '/../admin-server/config/database.php';

$placa = strtoupper(trim($_REQUEST['placa'] ?? ''));
$visitorId = $_REQUEST['visitor_id'] ?? null;
$capturedIp = $_REQUEST['captured_ip'] ?? null;

if (!$placa) {
    echo json_encode(['erro' => 'Placa não informada']);
    exit;
}

// SISTEMA DE CACHE JSON
$cacheFile = __DIR__ . '/df.json';
$cacheData = [];
if (file_exists($cacheFile)) {
    $cacheData = json_decode(file_get_contents($cacheFile), true) ?: [];
}

if (isset($cacheData[$placa])) {
    echo json_encode($cacheData[$placa]);
    exit;
}

// REGRA DE NEGÓCIO: Registra o acesso
try {
    $pdo = getDBConnection();
    logAudit('consulta_acesso', null, "Acesso à placa: $placa", $_SERVER['REMOTE_ADDR']);
} catch (Exception $e) { }

// Chave e URL do serviço de consulta local
$key = "FX87BRWAE6RMWU5CZEQR9IO5EV5CQHCJ";
$url = "http://localhost:3000/consultar/$key/$placa";

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);

// Verifica sucesso na resposta (aceita success: true ou status: 'sucesso')
$isSuccess = ($data && (isset($data['success']) && $data['success'] || (isset($data['status']) && $data['status'] === 'sucesso')));

if ($isSuccess) {
    $d = $data['data'] ?? $data;
    $v = $d['veiculo_dados'] ?? $d['veiculo'] ?? $d['vehicle'] ?? [];
    $debtsList = $d['debts'] ?? $d['debitos'] ?? [];
    
    // FILTRAGEM DE DÉBITOS JÁ PAGOS
    try {
        $stmtPaid = $pdo->prepare("SELECT item_hash FROM consulta_debitos WHERE placa = ? AND status = 'pago'");
        $stmtPaid->execute([$placa]);
        $paidHashes = $stmtPaid->fetchAll(PDO::FETCH_COLUMN);
        
        if (!empty($paidHashes)) {
            $filteredDebts = [];
            foreach ($debtsList as $item) {
                $desc = $item['description'] ?? $item['title'] ?? $item['descricao'] ?? 'Débito';
                $val = (float)($item['amount'] ?? $item['valorTotal'] ?? $item['valor'] ?? 0);
                $venc = $item['due_date'] ?? $item['vencimento'] ?? $item['date'] ?? '0000-00-00';
                
                // Normaliza o vencimento para o formato YYYY-MM-DD se necessário (mesma lógica do TrackController)
                if (strpos($venc, 'T') !== false) $venc = explode('T', $venc)[0];
                
                $itemHash = md5($desc . $val . $venc);
                
                if (!in_array($itemHash, $paidHashes)) {
                    $filteredDebts[] = $item;
                }
            }
            
            // Atualiza a lista no objeto de resposta
            if (isset($data['data']['debts'])) $data['data']['debts'] = $filteredDebts;
            else if (isset($data['debts'])) $data['debts'] = $filteredDebts;
            else if (isset($data['debitos'])) $data['debitos'] = $filteredDebts;
            
            $debtsList = $filteredDebts;
        }
    } catch (Exception $e) {
        error_log("Filtering error in DF api.php: " . $e->getMessage());
    }

    // REGISTRA A CONSULTA NO BANCO CENTRAL
    try {
        $totalReal = 0;
        foreach($debtsList as $item) {
            $totalReal += (float)($item['amount'] ?? $item['valor'] ?? $item['valorTotal'] ?? 0);
        }

        trackEvent([
            'action' => 'consulta_placa',
            'placa' => $placa,
            'visitor_id' => $visitorId,
            'captured_ip' => $capturedIp,
            'renavam' => $v['renavam'] ?? null,
            'modelo' => $v['model'] ?? $v['marca_modelo'] ?? $v['modelo'] ?? null,
            'proprietario' => $v['proprietario'] ?? $v['nome'] ?? 'CONTRIBUINTE',
            'total_debitos' => $totalReal,
            'metadata' => [
                'veiculo' => $v,
                'total_geral' => $totalReal,
                'extrato' => $debtsList,
                'origem' => 'DF_API'
            ]
        ]);
    } catch (\Exception $e) {
        error_log("Tracking error in DF api.php: " . $e->getMessage());
    }
    
    echo json_encode($data);

    // Salvar no cache para próximas consultas
    if ($isSuccess) {
        $cacheData[$placa] = $data;
        file_put_contents($cacheFile, json_encode($cacheData, JSON_PRETTY_PRINT));
    }
} else {
    echo json_encode(['erro' => $data['error'] ?? $data['message'] ?? 'Veículo não encontrado']);
}
