const axios = require('/var/www/api_placa/node_modules/axios');
const CryptoJS = require('/var/www/api_placa/node_modules/crypto-js');
const { HttpsProxyAgent } = require('/var/www/api_placa/node_modules/https-proxy-agent');

async function getZignetDebts(vehicleId) {
    console.log(`[Zignet GO] Buscando débitos para o ID: ${vehicleId}...`);
    
    const proxyUrl = 'http://pkscabelim_gmail_com-country-br-ipv4-true:xcy2s9jsob@gate.nodemaven.com:8080';
    const agent = new HttpsProxyAgent(proxyUrl);

    const terminal = "4068707027";
    const fingerprint = "t9vF262pEP0uG0oFnk5q";

    const url = `https://nfbti53lkd.execute-api.us-east-2.amazonaws.com/dev/site/debts/${vehicleId}?document=&renavam=482447&chassi=&uf=GO&fingerprintId=${fingerprint}`;

    try {
        const response = await axios.get(url, {
            headers: {
                "terminal": terminal,
                "x-fingerprint-site-id": fingerprint,
                "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36",
                "origin": "https://www.zignet.com.br",
                "referer": "https://www.zignet.com.br/selecao-debitos"
            },
            httpsAgent: agent,
            timeout: 15000
        });

        // Este é o payload criptografado dos débitos
        const encryptedDebts = response.data.response;
        console.log("[Zignet GO] Débitos Criptografados Recebidos.");
        
        // A Zignet utiliza as chaves de sessão para descriptografar os débitos.
        // Se conseguirmos decifrar isso, teremos a lista completa (IPVA, Licenciamento, Multas).
        
        return {
            success: true,
            encrypted_payload: encryptedDebts,
            numberKey: response.data.numberKey,
            dateIsoStringKey: response.data.dateIsoStringKey
        };

    } catch (error) {
        console.error(`[Zignet GO] Erro ao buscar débitos: ${error.message}`);
        return { success: false, error: error.message };
    }
}

// Execução com o ID do seu veículo (PQA4703)
getZignetDebts(2555644).then(res => console.log(JSON.stringify(res, null, 2)));
