<?php
namespace Controllers;

use Core\Response;

class ApiKeyController
{
    private static $dbPath = '/var/www/api_placa/f7imr6zs30ovzazu/keys.db';

    public static function list()
    {
        if (!file_exists(self::$dbPath)) {
            Response::json(['status' => 'error', 'message' => 'Banco de dados da API não encontrado em ' . self::$dbPath], 404);
            return;
        }

        try {
            if (!in_array('sqlite', \PDO::getAvailableDrivers())) {
                throw new \Exception('Driver PDO SQLite não instalado no servidor.');
            }

            $pdo = new \PDO('sqlite:' . self::$dbPath);
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

            $stmt = $pdo->query('SELECT * FROM api_keys ORDER BY id DESC');
            $keys = $stmt->fetchAll(\PDO::FETCH_ASSOC);

            Response::json(['status' => 'success', 'data' => $keys]);
        }
        catch (\Exception $e) {
            $msg = 'Erro: ' . $e->getMessage();
            if (defined('DEBUG') && DEBUG) {
                $msg .= ' | No arquivo: ' . $e->getFile() . ':' . $e->getLine();
            }
            Response::json(['status' => 'error', 'message' => $msg], 500);
        }
    }

    public static function create()
    {
        Response::json(['status' => 'error', 'message' => 'Funcionalidade em desenvolvimento.'], 501);
    }

    public static function toggle()
    {
        $id = $_POST['id'] ?? null;
        if (!$id) {
            Response::json(['status' => 'error', 'message' => 'ID não fornecido.'], 400);
            return;
        }

        try {
            $pdo = new \PDO('sqlite:' . self::$dbPath);
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

            $stmt = $pdo->prepare('UPDATE api_keys SET active = CASE WHEN active = 1 THEN 0 ELSE 1 END WHERE id = :id');
            $stmt->execute([':id' => $id]);

            Response::json(['status' => 'success', 'message' => 'Status da chave atualizado.']);
        }
        catch (\Exception $e) {
            Response::json(['status' => 'error', 'message' => $e->getMessage()], 500);
        }
    }
}
