<?php
/**
 * Mostra e testa senha do super_admin
 * REMOVA ESTE ARQUIVO APÓS USO!
 */

header('Content-Type: text/html; charset=utf-8');
require_once __DIR__ . '/../config/database.php';

echo "<h1>Senha do Super Admin</h1><pre>";

try {
    $pdo = getDBConnection();

    // Buscar super admin
    $stmt = $pdo->query("SELECT id, username, email, password_hash, role FROM admin_users WHERE role = 'super_admin' OR (role = 'admin' AND site_id IS NULL) LIMIT 1");
    $admin = $stmt->fetch();

    if (!$admin) {
        echo "Nenhum super admin encontrado!\n";
        exit;
    }

    echo "Usuario: {$admin['username']}\n";
    echo "Email: {$admin['email']}\n";
    echo "Role: {$admin['role']}\n";
    echo "Hash: {$admin['password_hash']}\n\n";

    // Testar senhas comuns
    $senhasComuns = [
        'admin123',
        'admin',
        'password',
        '123456',
        'admin@123',
        'senha123',
        'teladkdev',
        'Sodeknas01@',
        '12345678',
        'admin1234'
    ];

    echo "=== Testando senhas comuns ===\n";
    $senhaEncontrada = null;

    foreach ($senhasComuns as $senha) {
        if (password_verify($senha, $admin['password_hash'])) {
            $senhaEncontrada = $senha;
            echo "SENHA ENCONTRADA: {$senha}\n";
            break;
        }
    }

    if (!$senhaEncontrada) {
        echo "Nenhuma senha comum corresponde ao hash.\n";
        echo "\nPara redefinir a senha, adicione ?reset=1 na URL\n";
    }

    // Redefinir senha se solicitado
    if (isset($_GET['reset'])) {
        $novaSenha = 'admin123';
        $novoHash = password_hash($novaSenha, PASSWORD_DEFAULT);

        $stmt = $pdo->prepare("UPDATE admin_users SET password_hash = ? WHERE id = ?");
        $stmt->execute([$novoHash, $admin['id']]);

        echo "\n=== SENHA REDEFINIDA ===\n";
        echo "Nova senha: {$novaSenha}\n";
    }

} catch (Exception $e) {
    echo "ERRO: " . $e->getMessage();
}

echo "</pre>";
