<?php
/**
 * Teste de Conexão com Banco de Dados
 * APAGUE ESTE ARQUIVO APÓS USAR!
 */

header('Content-Type: application/json');

// Credenciais do banco secundário
$config = [
    'host' => 'srv1663.hstgr.io',
    'port' => '3306',
    'name' => 'u568188698_telas',
    'user' => 'u568188698_sodkne',
    'pass' => 'Sodeknastelas001@'
];

$result = [
    'test' => 'Database Connection Test',
    'time' => date('Y-m-d H:i:s'),
    'config_used' => [
        'host' => $config['host'],
        'db' => $config['name'],
        'user' => $config['user']
    ]
];

try {
    $dsn = "mysql:host={$config['host']};port={$config['port']};dbname={$config['name']};charset=utf8mb4";
    $pdo = new PDO($dsn, $config['user'], $config['pass'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
    
    $result['connection'] = 'SUCCESS';
    
    // Testar query de usuários
    $stmt = $pdo->query("SELECT id, username, email, role, is_active FROM admin_users");
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $result['users'] = $users;
    
    // Testar login com admin/admin123
    $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ? AND is_active = 1");
    $stmt->execute(['admin']);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        $result['user_found'] = true;
        $result['password_hash'] = substr($user['password_hash'], 0, 20) . '...';
        
        // Testar verificação de senha
        $testPassword = 'admin123';
        $hashToTest = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi';
        
        $result['password_verify_test'] = password_verify($testPassword, $hashToTest) ? 'PASS' : 'FAIL';
        $result['password_verify_db'] = password_verify($testPassword, $user['password_hash']) ? 'PASS' : 'FAIL';
    } else {
        $result['user_found'] = false;
    }
    
} catch (PDOException $e) {
    $result['connection'] = 'FAILED';
    $result['error'] = $e->getMessage();
}

echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
