const { chromium } = require('playwright');

(async () => {
  console.log('🚀 Iniciando simulação de visitas em todos os estados...');
  
  const sites = [
    'https://df-debito.com',
    'https://go-debito.com',
    'https://mg-debito.com',
    'https://ms-debito.com',
    'https://mt-debito.com',
    'https://pr-debito.com',
    'https://rj-debito.com',
    'https://rs-debito.com',
    'https://sc-debito.com'
  ];

  const browser = await chromium.launch({ headless: true });
  const context = await browser.newContext({
    userAgent: 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36',
    viewport: { width: 1280, height: 720 }
  });

  for (const url of sites) {
    try {
      const page = await context.newPage();
      console.log(`- Acessando: ${url}`);
      
      // Acessar o site e esperar o carregamento inicial
      await page.goto(url, { waitUntil: 'networkidle', timeout: 30000 });
      
      // Esperar 3 segundos para garantir que os scripts de track sejam disparados
      await page.waitForTimeout(3000);
      
      const title = await page.title();
      console.log(`  ✅ Sucesso: ${title}`);
      
      await page.close();
    } catch (error) {
      console.log(`  ❌ Falha ao acessar ${url}: ${error.message}`);
    }
  }

  await browser.close();
  console.log('
✨ Simulação concluída! Verifique seu Dashboard agora.');
})();
