<?php
define('ADMIN_SERVER_URL', 'http://localhost');
define('SITE_API_KEY', 'sk_2b0b286cbbbc3471afd8f7f8fabd62df');
define('SITE_TIMEZONE', 'America/Sao_Paulo');
date_default_timezone_set(SITE_TIMEZONE);
define('CONFIG_CACHE_TTL', 300);
define('CACHE_DIR', __DIR__ . '/cache');

function adminServerRequest($endpoint, $method = 'GET', $data = null) {
    $url = ADMIN_SERVER_URL . '/api/admin.php?action=' . $endpoint;
    $headers = array('Content-Type: application/json', 'X-API-Key: ' . SITE_API_KEY);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    if ($method === 'POST') {
        curl_setopt($ch, CURLOPT_POST, true);
        if ($data) curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    }
    $res = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($httpCode >= 200 && $httpCode < 300) {
        return json_decode($res, true);
    }
    return null;
}

function trackEvent($payload) {
    $payload["timestamp_client"] = date("Y-m-d H:i:s");
    $payload['api_key'] = SITE_API_KEY;
    
    // Captura o IP bruto para o servidor central processar via ip-api.com
    if (!isset($payload['captured_ip']) || empty($payload['captured_ip'])) {
        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'] ?? $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['REMOTE_ADDR'] ?? '';
        if (strpos($ip, ',') !== false) $ip = trim(explode(',', $ip)[0]);
        $payload['captured_ip'] = $ip;
    }
    
    $payload['ua'] = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
    $payload['timestamp_client'] = date('Y-m-d H:i:s');
    
    $response = adminServerRequest('track', 'POST', $payload);
    // DEBUG: Log the full response from adminServerRequest
    file_put_contents(__DIR__ . '/admin_response_log.txt', date('Y-m-d H:i:s') . ' - ADMIN RESPONSE: ' . json_encode($response, JSON_UNESCAPED_UNICODE) . "\n", FILE_APPEND);
    return $response && ($response['status'] ?? '') === 'success';
}

function getPixConfig() {
    $res = adminServerRequest('pix-config');
    return $res['data'] ?? array('pixKey' => '', 'receiverName' => 'PAGAMENTO', 'receiverCity' => 'SAO PAULO');
}