<?php
// Script de Diagnóstico Robusto - Dados Reais
header('Content-Type: text/plain');

$tests = [
    ['site' => 'rs', 'param' => 'placa=IGP0A50', 'desc' => 'FORD/KA (RS) sem debitos'],
    ['site' => 'mt', 'param' => 'placa=QCV7G34', 'desc' => 'RANDON RE DL (MT) sem debitos'],
    ['site' => 'mt', 'param' => 'placa=QCI8J44', 'desc' => 'RANDON RE DL (MT) com Licenciamento 2026'],
    // ['site' => 'sp', 'param' => 'placa=EPO3390', 'desc' => 'SP sem debitos'], // SP não existe
    ['site' => 'sc', 'param' => 'placa=AKL2684', 'desc' => 'SCHIFFER (SC) com 1 Multa'],
    ['site' => 'rs', 'param' => 'placa=IQP0866', 'desc' => 'SUNDOWN/MAX (RS) com Licenciamento 2026'],
    ['site' => 'pr', 'param' => 'placa=BCT5F40', 'desc' => 'CHEVROLET ONIX (PR) com Varios Debitos'],
    ['site' => 'sc', 'param' => 'placa=MEL8603', 'desc' => 'SC sem debitos'],
    ['site' => 'df', 'param' => 'placa=JHQ2375', 'desc' => 'FIAT/PALIO (DF) com 5 Multas'],
    ['site' => 'ms', 'param' => 'placa=QAZ8C17', 'desc' => 'MMC/OUTLANDER (MS) com IPVA/Multa'],
    ['site' => 'mg', 'param' => 'renavam=00688384404', 'desc' => 'FIAT/UNO (MG) Licenciamento 2026'],
    ['site' => 'rj', 'param' => 'renavam=00887775063', 'desc' => 'YAMAHA YBR (RJ) IPVA 2021']
];

echo "=== TESTE DE ROTAS COM DADOS REAIS ===\n\n";

foreach ($tests as $t) {
    $site = $t['site'];
    $url = "http://localhost/$site/api.php?" . $t['param'];
    
    echo "SITE: [" . strtoupper($site) . "] - " . $t['desc'] . "\n";
    echo "URL: $url\n";

    $start = microtime(true);
    $response = @file_get_contents($url);
    $time = round(microtime(true) - $start, 2);
    
    $json = json_decode($response, true);

    if ($json) {
        $status = "OK";
        if (isset($json['success'])) {
            $status = $json['success'] ? "SUCCESS" : "ERROR_MSG (" . ($json['error'] ?? 'No msg') . ")";
        } elseif (isset($json['status'])) {
            $status = strtoupper($json['status']);
        }
        
        echo "   -> Resposta: ✅ $status ({$time}s)\n";
        
        // Verificações específicas de conteúdo
        if ($site == 'mg' && isset($json['resultado']['veiculo']['marcaModelo'])) {
            echo "      Veiculo: " . $json['resultado']['veiculo']['marcaModelo'] . "\n";
        } elseif ($site == 'rj' && isset($json['veiculo']['deModelo'])) {
            echo "      Veiculo: " . $json['veiculo']['deModelo'] . "\n";
        } elseif (isset($json['data']['veiculo_dados']['marca_modelo'])) {
             echo "      Veiculo: " . $json['data']['veiculo_dados']['marca_modelo'] . "\n";
        }
    } else {
        echo "   -> Resposta: ❌ FALHA OU RESPOSTA INVALIDA ({$time}s)\n";
        if ($response) echo "      RAW: " . substr(strip_tags($response), 0, 100) . "...\n";
    }
    echo "--------------------------------------------------\n";
}

echo "\n=== FIM DOS TESTES ===\n";
