<?php
require_once __DIR__ . '/admin-server/config/database.php';
$pdo = getDBConnection();

try {
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "--- TESTE DE INSERÇÃO ROBUSTA ---\n";
    
    $vid = "test_diag_" . time();
    $metadata = json_encode(['test' => true]);
    $eventLog = json_encode(['type' => 'test', 'time' => date('Y-m-d H:i:s')]);
    
    $sql = "INSERT INTO consultas (site_id, visitor_id, ip_address, user_agent, status_consulta, status_pagamento, visit_at, metadata)
            VALUES (14, ?, '1.2.3.4', 'Mozilla/5.0', 'aguardando', 'aguardando', NOW(), ?)
            ON DUPLICATE KEY UPDATE 
            metadata = JSON_MERGE_PATCH(IFNULL(metadata, '{}'), CAST(? AS JSON))";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$vid, $metadata, $metadata]);
    
    echo "Inserção 1 (Simples): SUCESSO\n";
    
    // Testar o UPDATE com o histórico que pode estar quebrando
    $sql2 = "UPDATE consultas SET 
             metadata = JSON_ARRAY_APPEND(IFNULL(metadata, '{\"event_history\": []}'), '$.event_history', CAST(? AS JSON))
             WHERE visitor_id = ?";
    
    try {
        $stmt2 = $pdo->prepare($sql2);
        $stmt2->execute([$eventLog, $vid]);
        echo "Inserção 2 (Histórico): SUCESSO\n";
    } catch (Exception $e) {
        echo "Inserção 2 (Histórico): FALHOU - " . $e->getMessage() . "\n";
    }

} catch (Exception $e) {
    echo "ERRO GERAL: " . $e->getMessage() . "\n";
}
