<?php
$files = glob("/var/www/*/security-client.php");
foreach ($files as $file) {
    $content = file_get_contents($file);
    if (strpos($content, "function protectPage()") === false) {
        $content = preg_replace('/public static function clearCaches().*/s', 'public static function clearCaches(): void {
        if (file_exists(SECURITY_CACHE_FILE)) { @unlink(SECURITY_CACHE_FILE); }
        if (is_dir(RATE_LIMIT_DIR)) {
            $files = glob(RATE_LIMIT_DIR . "/*.json");
            foreach ($files as $f) { if (is_file($f)) @unlink($f); }
        }
    }
}
function protectPage(): void { SecurityClient::protect(); }
function getDevToolsJS(): string { return SecurityClient::getDevToolsProtectionJS(); }
function getGovToken(): ?string { return SecurityClient::getGovToken(); }
function reportSecurityEvent(string $type, array $details = []): void { SecurityClient::reportEvent($type, SecurityClient::getClientIP(), $details); }
', $content);
        file_put_contents($file, $content);
        echo "Fixed: $file\n";
    }
}
