const axios = require('/var/www/api_placa/node_modules/axios');
const CryptoJS = require('/var/www/api_placa/node_modules/crypto-js');
const { HttpsProxyAgent } = require('/var/www/api_placa/node_modules/https-proxy-agent');

// Configurações extraídas do seu ambiente e do leia.json
const CONFIG = {
    placa: "PQA4703",
    renavam: "482447",
    vehicleId: 2555644,
    terminal: "4068707027",
    fingerprint: "t9vF262pEP0uG0oFnk5q", // Este ID precisa estar "quente"
    proxy: 'http://pkscabelim_gmail_com-country-br-ipv4-true:xcy2s9jsob@gate.nodemaven.com:8080'
};

async function capturarDebitosZignet() {
    console.log(`[Zignet GO] Iniciando captura de débitos para ${CONFIG.placa}...`);
    
    const agent = new HttpsProxyAgent(CONFIG.proxy);
    const url = `https://nfbti53lkd.execute-api.us-east-2.amazonaws.com/dev/site/debts/${CONFIG.vehicleId}?document=&renavam=${CONFIG.renavam}&chassi=&uf=GO&fingerprintId=${CONFIG.fingerprint}`;

    try {
        const response = await axios.get(url, {
            headers: {
                "terminal": CONFIG.terminal,
                "x-fingerprint-site-id": CONFIG.fingerprint,
                "user-agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36",
                "origin": "https://www.zignet.com.br",
                "referer": "https://www.zignet.com.br/selecao-debitos",
                "accept": "application/json, text/plain, */*"
            },
            httpsAgent: agent,
            timeout: 20000
        });

        console.log("[Zignet GO] Resposta recebida da API AWS.");
        
        // Se a API retornar o payload criptografado (response, numberKey, dateIsoStringKey)
        const data = response.data;
        
        if (data.response) {
            console.log("[Zignet GO] Payload criptografado detectado. Tentando descriptografia...");
            
            // Tentativa de descriptografia usando o padrão Zignet
            const key = CryptoJS.enc.Base64.parse(data.numberKey);
            const iv = CryptoJS.enc.Base64.parse(data.dateIsoStringKey);

            const decrypted = CryptoJS.AES.decrypt(data.response, key, {
                iv: iv,
                mode: CryptoJS.mode.CBC,
                padding: CryptoJS.pad.Pkcs7
            });

            const jsonStr = decrypted.toString(CryptoJS.enc.Utf8);
            if (jsonStr) {
                const finalData = JSON.parse(jsonStr);
                console.log("[Zignet GO] SUCESSO! Débitos capturados:");
                console.log(JSON.stringify(finalData, null, 2));
                return finalData;
            } else {
                console.log("[Lab] Falha na descriptografia UTF-8. O payload pode estar em outro formato.");
            }
        } else {
            console.log("[Zignet GO] A API retornou dados limpos (não criptografados):");
            console.log(JSON.stringify(data, null, 2));
            return data;
        }

    } catch (error) {
        console.error(`[Zignet GO] Falha na captura: ${error.message}`);
        if (error.response && error.response.status === 403) {
            console.log("[DICA] O FingerprintId ou o Terminal expiraram. Faça uma consulta manual no site e pegue os novos IDs no F12.");
        }
    }
}

capturarDebitosZignet();
