# MCP Utils Server

Servidor de Protocolo de Contexto de Modelo (MCP) para utilitários do projeto.

## Funcionalidades

- **web_search**: Realiza buscas na web (Placeholder).
- **generate_proxy**: Retorna a URL do proxy configurado (NodeMaven).
- **solve_captcha**: Integração com 2Captcha para resolver Turnstile/ReCaptcha.

## Instalação

```bash
cd /var/www/mcp-service
npm install
```

## Configuração

Edite o arquivo `.env` com suas chaves de API:

- `PROXY_HOST`: Host do proxy.
- `PROXY_AUTH`: Credenciais do proxy.
- `CAPTCHA_API_KEY`: Sua chave do 2Captcha.

## Execução

Para rodar o servidor em modo STDIO (padrão para MCP):

```bash
node index.js
```

## Integração com Claude Desktop

Adicione à sua configuração do Claude Desktop:

```json
{
  "mcpServers": {
    "utils": {
      "command": "node",
      "args": ["/var/www/mcp-service/index.js"]
    }
  }
}
```
