const axios = require('axios');
const { HttpsProxyAgent } = require('https-proxy-agent');
const http = require('http'); // Necessário para o proxy HTTP

// ---
// Configurações
// ---
const EXTERNAL_API_URL = 'http://52.15.37.114/dk/api.php';

const PROXY_CONFIG = {
    host: 'gate.nodemaven.com',
    port: 8080,
    username: 'pkscabelim_gmail_com-country-br-ipv4-true',
    password: 'xcy2s9jsob'
};

// ---
// Funções Auxiliares
// ---
function getProxyAgent() {
    if (!PROXY_CONFIG.enabled) return undefined;
    const proxyUrl = `http://${PROXY_CONFIG.username}:${PROXY_CONFIG.password}@${PROXY_CONFIG.host}:${PROXY_CONFIG.port}`;
    return new HttpsProxyAgent(proxyUrl);
}

function getUrlWithParams(baseUrl, params) {
    const url = new URL(baseUrl);
    for (const key in params) {
        if (params.hasOwnProperty(key) && params[key]) {
            url.searchParams.append(key, params[key]);
        }
    }
    return url.toString();
}

// ---
// Função Principal de Consulta
// ---
async function consultarMS(placa, renavam) {
    console.log(`Consultando MS para Placa: ${placa}, Renavam: ${renavam}`);
    try {
        const agent = getProxyAgent();
        const url = getUrlWithParams(EXTERNAL_API_URL, { placa: placa, renavam: renavam });

        const response = await axios.get(url, {
            headers: {
                'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36'
            },
            httpAgent: agent, // Usa o proxy agent para requisições HTTP
            proxy: false,     // Necessário quando se usa httpAgent
            timeout: 30000    // Timeout de 30 segundos
        });

        console.log("--- Resposta da API Externa ---");
        console.log(JSON.stringify(response.data, null, 2));
        return response.data;

    } catch (error) {
        console.error("Erro ao consultar API Externa MS:", error.message);
        if (error.response) {
            console.error("Status:", error.response.status);
            console.error("Data:", error.response.data);
        }
        return { success: false, error: error.message };
    }
}

// ---
// Execução
// ---
const placaArg = process.argv[2];
const renavamArg = process.argv[3];

if (!placaArg || !renavamArg) {
    console.error("Uso: node ms.js <placa> <renavam>");
    process.exit(1);
}

consultarMS(placaArg, renavamArg);
