<?php

header_remove('X-Powered-By');
require_once __DIR__ . '/client-config.php';

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

try {
    $forceRefresh = isset($_GET['refresh']) || isset($_GET['nocache']);
    $config = getPixConfig($forceRefresh);
    if ($forceRefresh) clearCache();
    echo json_encode(['status' => 'success', 'data' => $config]);
} catch (Exception $e) {
    echo json_encode(['status' => 'success', 'data' => ['pixKey' => '', 'receiverName' => 'PAGAMENTO', 'receiverCity' => 'SAO PAULO']]);
}
