<?php

header_remove('X-Powered-By');
ini_set('expose_php', 'off');

require_once __DIR__ . '/client-config.php';
require_once __DIR__ . '/security-client.php';

try {
    SecurityClient::protect();
} catch (Exception $e) {
    
    error_log("Security init error: " . $e->getMessage());
}

function securityJS(): string
{
    return SecurityClient::getDevToolsProtectionJS();
}

function securityConfigJSON(): string
{
    $config = SecurityClient::getConfig();
    
    
    $frontendConfig = [
        'block_devtools' => (bool)($config['block_devtools'] ?? false),
        'block_right_click' => (bool)($config['block_right_click'] ?? false),
        'block_view_source' => (bool)($config['block_view_source'] ?? false),
        'block_copy' => (bool)($config['block_copy'] ?? false)
    ];
    
    return json_encode($frontendConfig);
}

function shouldShowCaptcha(): bool
{
    $config = SecurityClient::getConfig();
    return (bool)($config['antibot_captcha_enabled'] ?? false);
}

function getConfiguredGovToken(): ?string
{
    return SecurityClient::getGovToken();
}
