<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
require_once __DIR__ . '/client-config.php';

$placa = strtoupper(trim($_REQUEST['placa'] ?? ''));
$renavam = preg_replace('/\D/', '', $_REQUEST['renavam'] ?? '');
$capturedIp = $_REQUEST['captured_ip'] ?? null;

if (empty($placa)) {
    echo json_encode(['success' => false, 'error' => 'Placa obrigatória']);
    exit;
}

$key = "FX87BRWAE6RMWU5CZEQR9IO5EV5CQHCJ";

// Se não tiver renavam, usa Main Server (DOK/Procergs) ou Zapay como fallback
if (empty($renavam)) {
    // Tenta primeiro via Main Server (Porta 3002) pois é otimizado para RS
    $url = "http://localhost:3002/api/v1/vehicle/debts?plate=$placa&uf=RS";
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    $data = json_decode($response, true);
    
    if ($httpCode === 200 && $data && isset($data['status']) && $data['status'] === 'sucesso') {
        trackEvent([
            'action' => 'consulta_placa',
            'placa' => $placa,
            'captured_ip' => $capturedIp,
            'metadata' => ['origem' => 'rs/api.php (MainServer)']
        ]);
        echo json_encode($data);
        exit;
    }
    
    // Se falhar no Main Server, tenta via Zapay
    $url = "http://localhost:3000/consultar/$key/$placa";
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $data = json_decode($response, true);
    
    if ($data && $data['success']) {
        echo json_encode($data['data']);
        exit;
    }
}

// Se tiver Renavam ou se os fallbacks falharam, tenta a lógica original (PCS Procergs direto)
// Nota: Esta parte requer um Token válido.
try {
    $url = "https://pcsdetran.procergs.com.br/pcsdetran/rest/veiculos/{$placa}?renavam={$renavam}&contabiliza=false";
    $token = "TOKEN_AQUI"; 

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_HTTPHEADER => ['Authorization: Bearer ' . $token],
        CURLOPT_PROXY => 'gate.nodemaven.com:8080',
        CURLOPT_PROXYUSERPWD => 'sp99852541:xcy2s9jsob'
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode === 200) {
        echo $response;
    } else {
        echo json_encode(['success' => false, 'error' => "Veículo não localizado ou Token expirado (RS)."]);
    }

} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
