<?php
/**
 * Endpoint para limpar todos os dados do sistema
 * Mantém apenas a senha do administrador
 */
require_once __DIR__ . '/require_auth.php';

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

try {
    $dbPath = __DIR__ . '/admin.db';
    $pdo = new PDO('sqlite:' . $dbPath);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Iniciar transação
    $pdo->beginTransaction();

    // 1. Limpar tabela de eventos (todas as visitas, consultas, PIX, etc.)
    $pdo->exec("DELETE FROM events");

    // 2. Limpar settings EXCETO a senha do admin
    $pdo->exec("DELETE FROM settings WHERE key != 'admin_password_hash'");

    // Commit da transação
    $pdo->commit();

    // 3. Limpar também o arquivo JSON legado se existir
    $jsonFile = __DIR__ . '/admin_data.json';
    if (file_exists($jsonFile)) {
        $emptyData = [
            'visits' => [],
            'cnpjConsultas' => [],
            'pixGerados' => [],
            'pixPagos' => [],
            'ips' => (object)[],
            'locations' => (object)[],
            'companies' => (object)[],
            'dailyStats' => (object)[],
            'meta' => [
                'created' => date('c'),
                'lastUpdate' => date('c'),
                'version' => '1.0.0'
            ]
        ];
        file_put_contents($jsonFile, json_encode($emptyData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    }

    echo json_encode([
        'status' => 'success',
        'message' => 'Todos os dados foram limpos com sucesso. A senha do admin foi mantida.'
    ]);

} catch (Exception $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack();
    }
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Erro ao limpar dados: ' . $e->getMessage()
    ]);
}
