<?php
/**
 * Client Config - Fornece configurações para o cliente (api.php)
 * Este arquivo é incluído pelo api.php para buscar o token de autenticação
 */

/**
 * Obtém o token de autenticação da API do DETRAN
 * @return string|null Token ou null se não configurado
 */
function getDetranApiToken() {
    $dbPath = __DIR__ . '/admin/admin.db';
    
    // Verifica se o banco existe
    if (!file_exists($dbPath)) {
        return null;
    }
    
    try {
        $pdo = new PDO('sqlite:' . $dbPath);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $stmt = $pdo->prepare('SELECT value FROM settings WHERE key = :key LIMIT 1');
        $stmt->execute([':key' => 'api_config']);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($row && isset($row['value'])) {
            $decoded = json_decode($row['value'], true);
            if (json_last_error() === JSON_ERROR_NONE && isset($decoded['apiToken'])) {
                return trim($decoded['apiToken']);
            }
        }
    } catch (Exception $e) {
        error_log('Erro ao obter token da API: ' . $e->getMessage());
    }
    
    return null;
}

/**
 * Verifica se o token da API está configurado
 * @return bool
 */
function hasDetranApiToken() {
    $token = getDetranApiToken();
    return !empty($token);
}
