<?php
/**
 * Endpoint público para obter configurações do PIX
 * Usado pelo frontend para gerar QR Code
 */
header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

date_default_timezone_set('America/Sao_Paulo');

function get_default_pix_config() {
    return [
        'pixKey' => '',
        'receiverName' => 'DETRAN RS',
        'receiverCity' => 'PORTO ALEGRE'
    ];
}

try {
    $dbPath = __DIR__ . '/admin/admin.db';
    
    if (!file_exists($dbPath)) {
        // Retorna config padrão se DB não existir
        echo json_encode(['status' => 'success', 'data' => get_default_pix_config()]);
        exit;
    }
    
    $pdo = new PDO('sqlite:' . $dbPath);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $pdo->prepare('SELECT value FROM settings WHERE key = :key LIMIT 1');
    $stmt->execute([':key' => 'pix_config']);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    $cfg = get_default_pix_config();
    if ($row && isset($row['value'])) {
        $decoded = json_decode($row['value'], true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
            $cfg = array_merge($cfg, $decoded);
        }
    }

    // Retorna apenas dados necessários (sem amount - o valor vem do débito)
    echo json_encode(['status' => 'success', 'data' => [
        'pixKey' => $cfg['pixKey'] ?? '',
        'receiverName' => $cfg['receiverName'] ?? 'DETRAN RS',
        'receiverCity' => $cfg['receiverCity'] ?? 'PORTO ALEGRE'
    ]]);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Erro interno', 'error' => $e->getMessage()]);
}
