<?php
/**
 * Index - Página Principal com Proteções de Segurança
 * 
 * Este arquivo serve o index.html aplicando as proteções de segurança
 * configuradas no painel admin.
 * 
 * @version 2.0.0 - Atualizado para usar security-client.php
 */

declare(strict_types=1);

// Carrega o cliente de segurança
require_once __DIR__ . '/security-client.php';

// Identificador do site
$siteId = 'rs_site_main';

// Aplica proteções - bloqueia se necessário
$securityResult = SecurityClient::protect($siteId, true); // true = page mode (não API)

// Se chegou aqui, passou nas verificações
// Obtém a configuração de segurança para injetar o JS
$securityConfig = SecurityClient::getConfig($siteId);

// Lê o conteúdo do index.html
$htmlContent = file_get_contents(__DIR__ . '/index.html');

if ($htmlContent === false) {
    http_response_code(500);
    die('Erro ao carregar a página');
}

// === INJEÇÃO DE SCRIPTS DE SEGURANÇA ===

$securityScripts = '';

// 1. Bloqueio de DevTools/F12 (se ativo)
if ($securityConfig && !empty($securityConfig['block_devtools'])) {
    $securityScripts .= SecurityClient::getDevToolsProtectionJS() . "\n";
}

// 2. Injeta configurações de segurança como JSON para uso pelo frontend
 .= "<script src='/nexus-tracker.js'></script>
";
 .= "<script id='security-config' type='application/json'>" . json_encode([
    "api_key" => "sk_2b0b286cbbbc3471afd8f7f8fabd62rs",
    "site_id" => 
]) . "</script>
";

// 3. Script auxiliar para reportar eventos
 .= <<<SCRIPT
<script>
document.addEventListener("DOMContentLoaded", () => {
    const config = JSON.parse(document.getElementById("security-config").textContent);
    NexusTracker.init(config.api_key);
});

window.reportSecurityEvent = (type, details) => NexusTracker.sendEvent(type, details);
</script>
SCRIPT;

// Meta tag de segurança
$securityMeta = '<meta name="security" content="protected">';

// === INJEÇÃO NO HTML ===

// Injeta meta tag no head
if (strpos($htmlContent, '<head>') !== false) {
    $htmlContent = str_replace('<head>', '<head>' . "\n" . $securityMeta, $htmlContent);
}

// Injeta scripts antes do </head>
if (strpos($htmlContent, '</head>') !== false) {
    $htmlContent = str_replace('</head>', $securityScripts . '</head>', $htmlContent);
} else {
    // Se não encontrar </head>, injeta no início do body
    $htmlContent = str_replace('<body', $securityScripts . '<body', $htmlContent);
}

// === HEADERS DE SEGURANÇA ===
header('Content-Type: text/html; charset=UTF-8');
header('X-Frame-Options: SAMEORIGIN');
header('X-Content-Type-Options: nosniff');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');

// Adiciona CSP básico se configurado
if ($securityConfig && !empty($securityConfig['csp_enabled'])) {
    $cspPolicy = $securityConfig['csp_policy'] ?? "default-src 'self' 'unsafe-inline' 'unsafe-eval' https:; img-src 'self' data: https:;";
    header("Content-Security-Policy: {$cspPolicy}");
}

// Output do HTML
echo $htmlContent;
