<?php
require_once __DIR__ . '/admin-server/config/database.php';

function updateAllPixKeys($newKey) {
    $pdo = getDBConnection();
    
    // Criptografa a nova chave
    $encryptedKey = encryptData($newKey);
    
    try {
        // Atualiza todas as chaves existentes
        $stmt = $pdo->prepare("UPDATE pix_config SET pix_key = ?, pix_key_type = 'random', updated_at = NOW()");
        $stmt->execute([$encryptedKey]);
        
        $count = $stmt->rowCount();
        echo "Sucesso: $count registros atualizados na tabela pix_config.
";
        
        // Verifica se o RJ (Site ID 10) tem configuração, se não, cria uma
        $stmtCheck = $pdo->prepare("SELECT id FROM pix_config WHERE site_id = 10 LIMIT 1");
        $stmtCheck->execute();
        if (!$stmtCheck->fetch()) {
            $stmtInsert = $pdo->prepare("INSERT INTO pix_config (site_id, state, pix_key, pix_key_type, receiver_name, receiver_city, is_active, created_at) VALUES (10, 'RJ', ?, 'random', 'PAGAMENTO SERVICOS', 'RIO DE JANEIRO', 1, NOW())");
            $stmtInsert->execute([$encryptedKey]);
            echo "RJ: Configuração PIX criada para o site 10.
";
        }

    } catch (Exception $e) {
        echo "ERRO: " . $e->getMessage() . "
";
    }
}

updateAllPixKeys('225b1267-6162-43cd-9f09-b242e4700285');
