# 🎯 PGMEI Admin Dashboard

Sistema de analytics e dashboard administrativo para o PGMEI, que monitora em tempo real visitas, consultas de CNPJ, transações PIX e geolocalização de usuários **SEM backend Node.js**.

## ✨ Características

- **100% Frontend**: Funciona apenas com JavaScript puro, sem servidor
- **Dados Reais**: **NÃO há dados mock/simulados** - apenas dados reais coletados da aplicação
- **Arquivo .db JSON**: Usa localStorage como "banco de dados" simulado
- **Tempo Real**: Auto-refresh a cada 30 segundos dos dados reais
- **Responsive**: Design moderno e adaptável
- **Gráficos Interativos**: Charts.js para visualizações

## � Como Usar

### 1. Configuração
1. Copie a pasta `admin/` para o diretório do seu projeto PGMEI
2. O tracking já está integrado no sistema principal (index.html e script.js)
3. Abra `admin/index.html` no navegador

### 2. Acesso ao Dashboard
- **URL**: `admin/index.html`
- **Dados**: Carregados automaticamente do localStorage
- **Atualização**: A cada 30 segundos (apenas dados reais)

### 3. Teste do Sistema
- Use `admin/test-tracking.html` para simular eventos e testar o tracking
- Ou simplesmente use o sistema principal normalmente

## 📊 Métricas Coletadas

### Visitas
- Timestamp de acesso
- IP do usuário  
- Geolocalização (cidade/estado)
- User Agent
- Página visitada

### Consultas CNPJ
- CNPJ consultado
- Nome da empresa
- Sucesso/erro da consulta
- Tempo de resposta
- Mensagem de erro (se houver)

### Transações PIX
- PIX gerados
- PIX pagos
- Valor das transações
- Status (gerado/pago/erro)
- QR Code e código copy-paste

### Empresas
- Ranking das empresas mais consultadas
- Quantidade de consultas por CNPJ
- Histórico de atividades

## �️ Arquitetura

```
admin/
├── index.html          # Dashboard principal
├── admin.js           # Lógica do admin (SEM mocks)
├── admin_data.json    # Arquivo .db (persistência)
├── test-tracking.html # Página de teste
└── README.md          # Esta documentação
```

### Fluxo de Dados

1. **Sistema Principal** (index.html, script.js)
   - Coleta eventos reais de usuários
   - Salva no localStorage como "admin_db_backup"
   
2. **Admin Dashboard** (admin/index.html)
   - Lê dados do localStorage
   - Exibe métricas e gráficos
   - Auto-refresh a cada 30s

## 🔧 Integração

### Tracking Automático
O sistema principal já tem integração completa:

```javascript
// Visitas
trackEvent('page_view', { page: 'home' });

// Consultas CNPJ
trackCNPJConsulta(cnpj, razaoSocial, success, responseTime, errorMessage);

// PIX
trackPIX(pixId, cnpj, valor, status, qrCode, copyPaste);
```

### Personalização
Para adicionar novos eventos:

1. Edite `script.js` para adicionar tracking
2. Modifique `admin.js` para processar novos dados  
3. Atualize dashboard para exibir novas métricas

## � Dashboard Features

### Cards de Estatísticas
- Total de visitas
- Consultas CNPJ realizadas  
- PIX gerados
- PIX pagos
- Variação percentual diária

### Gráficos
- **Visitas por Hora**: Linha temporal das últimas 24h (dados reais)
- **Países**: Distribuição geográfica dos acessos
- **Status PIX**: Barras comparativas gerado vs pago
- **Tendência Semanal**: Visitas dos últimos 7 dias

### Tabelas
- **Atividades Recentes**: Log dos últimos eventos
- **Cidades**: Ranking de acessos por localização
- **Empresas**: Mais consultadas no sistema

## 🧪 Testes

### Arquivo de Teste
Use `admin/test-tracking.html` para:
- Simular visitas, consultas CNPJ e PIX
- Verificar se dados são salvos corretamente
- Limpar dados de teste
- Visualizar localStorage atual

### Verificação Manual
1. Abra o sistema principal (index.html)
2. Faça uma consulta CNPJ real
3. Gere um PIX  
4. Abra o admin (admin/index.html)
5. Verifique se os dados aparecem no dashboard

## ⚡ Performance

- **Dados Locais**: Sem chamadas de rede para carregar dados
- **Leve**: Apenas JavaScript puro + Chart.js
- **Rápido**: Carregamento instantâneo dos dados
- **Eficiente**: Auto-refresh otimizado

## 🔒 Dados

### Armazenamento
- **localStorage**: `admin_db_backup` (backup em tempo real)
- **Formato**: JSON estruturado
- **Persistência**: Dados mantidos entre sessões

### Estrutura de Dados
```json
{
  "visits": [...],
  "cnpjConsultas": [...], 
  "pixGerados": [...],
  "pixPagos": [...],
  "ips": {...},
  "locations": {...},
  "companies": {...},
  "dailyStats": {...}
}
```

## 🎯 Próximos Passos

- [ ] Integração com API real de geolocalização por IP
- [ ] Exportação de relatórios (CSV/PDF)
- [ ] Filtros por período/empresa
- [ ] Notificações em tempo real
- [ ] Backup automático em arquivo

## ⚠️ Importante

- **Dados Reais**: Este sistema **NÃO utiliza dados mock/simulados**
- **Produção**: Para uso em produção, considere implementar backend real
- **Segurança**: Em produção, implemente autenticação no admin
- **Backup**: Faça backup periódico dos dados do localStorage
```javascript
POST /api/track
{
  "action": "page_load",
  "metadata": { "page": "home" }
}
```

### Tracking de Consultas CNPJ
```javascript
POST /api/track-cnpj
{
  "cnpj": "00000000000191",
  "razao_social": "BANCO DO BRASIL SA",
  "success": true,
  "response_time": 1200
}
```

### Tracking de PIX
```javascript
POST /api/track-pix
{
  "pix_id": "PIX1234567890",
  "cnpj": "00000000000191",
  "valor": 125.50,
  "status": "gerado"
}
```

### Estatísticas Dashboard
```javascript
GET /api/stats
// Retorna estatísticas do dia atual

GET /api/visits-hourly
// Visitas por hora (últimas 24h)

GET /api/geo-stats
// Dados geográficos

GET /api/recent-activity
// Atividade recente

GET /api/top-companies
// Empresas mais consultadas
```

## 🗄️ Banco de Dados

O sistema usa SQLite com as seguintes tabelas:

### visits
- `id`: ID único
- `ip`: Endereço IP do visitante
- `timestamp`: Data/hora da visita
- `country`, `region`, `city`: Localização
- `latitude`, `longitude`: Coordenadas
- `action`: Ação realizada
- `metadata`: Dados adicionais (JSON)

### cnpj_consultas
- `id`: ID único
- `ip`: IP que fez a consulta
- `cnpj`: CNPJ consultado
- `razao_social`: Nome da empresa retornado
- `success`: Se a consulta foi bem-sucedida
- `response_time`: Tempo de resposta em ms
- `error_message`: Mensagem de erro (se houver)

### pix_transactions
- `id`: ID único
- `pix_id`: ID da transação PIX
- `ip`: IP que gerou o PIX
- `cnpj`: CNPJ relacionado
- `valor`: Valor da transação
- `status`: 'gerado' ou 'pago'
- `timestamp`: Data/hora de criação
- `paid_at`: Data/hora do pagamento

## 🔧 Configuração

### Variáveis de Ambiente
```bash
PORT=3001                    # Porta do servidor
NODE_ENV=production         # Ambiente
DB_PATH=./admin.db          # Caminho do banco SQLite
```

### CORS
O servidor está configurado para aceitar requisições de qualquer origem em desenvolvimento. Para produção, configure as origens permitidas:

```javascript
app.use(cors({
  origin: ['https://seudominio.com']
}));
```

## 📈 Métricas Disponíveis

### Cards Principais
1. **Total de Visitas**: Soma de todos os acessos
2. **Consultas CNPJ**: Número de consultas à API
3. **PIX Gerados**: Transações criadas
4. **PIX Pagos**: Transações efetivadas

### Gráficos
1. **Visitas por Hora**: Linha temporal das últimas 24h
2. **Distribuição por País**: Gráfico de pizza
3. **Status PIX**: Comparativo gerados vs pagos
4. **Tendência Semanal**: Atividade dos últimos 7 dias

### Tabelas
1. **Atividade Recente**: Últimas ações dos usuários
2. **Top Cidades**: Cidades com mais acessos
3. **Top Empresas**: CNPJs mais consultados

## 🔒 Segurança

- Headers de segurança com Helmet.js
- Sanitização de inputs
- Rate limiting (recomendado para produção)
- Logs de auditoria

## 🚀 Deploy em Produção

### 1. Configurar Processo
```bash
npm install -g pm2
pm2 start server.js --name "pgmei-admin"
pm2 startup
pm2 save
```

### 2. Nginx Proxy
```nginx
server {
    listen 80;
    server_name admin.seudominio.com;
    
    location / {
        proxy_pass http://localhost:3001;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_cache_bypass $http_upgrade;
    }
}
```

### 3. SSL com Let's Encrypt
```bash
certbot --nginx -d admin.seudominio.com
```

## 🔄 Backup e Manutenção

### Backup do Banco
```bash
# Backup automático diário
0 2 * * * cp /caminho/para/admin.db /backup/admin-$(date +\%Y\%m\%d).db
```

### Limpeza de Logs Antigos
```sql
-- Deletar registros mais antigos que 30 dias
DELETE FROM visits WHERE timestamp < datetime('now', '-30 days');
DELETE FROM cnpj_consultas WHERE timestamp < datetime('now', '-30 days');
DELETE FROM pix_transactions WHERE timestamp < datetime('now', '-30 days');
```

## 🐛 Troubleshooting

### Problemas Comuns

1. **Porta já em uso**:
   ```bash
   lsof -ti:3001 | xargs kill
   ```

2. **Banco de dados travado**:
   ```bash
   rm admin.db
   # Banco será recriado automaticamente
   ```

3. **Permissões de arquivo**:
   ```bash
   chmod 755 admin/
   chown -R user:user admin/
   ```

## 📞 Suporte

Para questões técnicas ou sugestões:
- 📧 Email: admin@pgmei.com
- 🐛 Issues: GitHub Issues
- 📖 Docs: [Documentação Completa]

---

**Status**: ✅ Sistema Completo e Funcional  
**Versão**: 1.0.0  
**Última Atualização**: $(date)
