<?php

declare(strict_types=1);

require_once __DIR__ . '/security-client.php';
require_once __DIR__ . '/client-config.php';

$siteId = 'rj_site_main';

// 1. PROTEÇÃO E RASTREIO AUTOMÁTICO DE SEGURANÇA
// Se for bloqueado, a função reportEvent interna já avisará o painel e encerrará o script
$securityResult = SecurityClient::protect($siteId, true); 
$securityConfig = SecurityClient::getConfig($siteId);

// 2. CARREGAMENTO DO CONTEÚDO
$htmlContent = file_get_contents(__DIR__ . '/index.html');

if ($htmlContent === false) {
    http_response_code(500);
    die('Erro ao carregar a página');
}

// 3. INJEÇÃO DE SEGURANÇA NO HTML
$securityScripts = SecurityClient::getDevToolsProtectionJS() . "\n";

$securityScripts .= '<script id="security-config" type="application/json">' . json_encode([
    'anti_bot' => $securityConfig['antibot_enabled'] ?? false,
    'rate_limit_enabled' => $securityConfig['rate_limit_enabled'] ?? false,
    'site_id' => $siteId
]) . '</script>' . "\n";

$securityScripts .= <<<SCRIPT
<script>
window.reportSecurityEvent = function(eventType, details = {}) {
    fetch('track.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ action: eventType, metadata: { ...details, site_id: '{$siteId}' } }),
        keepalive: true
    }).catch(() => {});
};
</script>
SCRIPT;

$securityMeta = '<meta name="security" content="protected">';

if (strpos($htmlContent, '<head>') !== false) {
    $htmlContent = str_replace('<head>', '<head>' . "\n" . $securityMeta, $htmlContent);
}

if (strpos($htmlContent, '</head>') !== false) {
    $htmlContent = str_replace('</head>', $securityScripts . '</head>', $htmlContent);
} else {
    $htmlContent = str_replace('<body', $securityScripts . '<body', $htmlContent);
}

header('Content-Type: text/html; charset=UTF-8');
header('X-Frame-Options: SAMEORIGIN');
header('X-Content-Type-Options: nosniff');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');

if ($securityConfig && !empty($securityConfig['csp_enabled'])) {
    $cspPolicy = $securityConfig['csp_policy'] ?? "default-src 'self' 'unsafe-inline' 'unsafe-eval' https:; img-src 'self' data: https:;";
    header("Content-Security-Policy: {$cspPolicy}");
}

echo $htmlContent;
