# 📊 Admin Dashboard - PGMEI Analytics

Sistema completo de analytics e monitoramento para a aplicação PGMEI com rastreamento de visitas, consultas CNPJ, geolocalização e transações PIX.

## 🚀 Características

### 📈 **Analytics em Tempo Real**
- **Visitas**: Contagem total e por hora
- **Consultas CNPJ**: Sucessos e falhas  
- **PIX**: Gerados vs Pagos
- **Geolocalização**: Por IP (simulada)

### 📊 **Gráficos Interativos**
- Visitas por hora (últimas 24h)
- Distribuição de países
- Status dos PIX (gerados/pagos/pendentes)
- Tendência semanal

### 🗂️ **Tabelas Detalhadas**
- Atividade recente (20 últimos eventos)
- Top cidades por visitas
- Top empresas por consultas CNPJ

### 💾 **Banco de Dados**
- Arquivo `admin_data.json` como "banco de dados"
- Backup em localStorage
- Auto-save a cada evento

## 🌐 Como Acessar

1. **Aplicação Principal**: `http://localhost:8081/index.html`
2. **Admin Dashboard**: `http://localhost:8081/admin/index.html`

## 🔧 Como Funciona

O sistema trackea automaticamente todas as ações na aplicação principal:

- ✅ **Visitas**: Página carregada
- ✅ **Consultas CNPJ**: API chamada com sucesso/erro  
- ✅ **PIX Gerados**: Modal de pagamento aberto
- ✅ **PIX Pagos**: Simulação de pagamento

## 💡 Teste o Sistema

1. Acesse a aplicação principal: `http://localhost:8081`
2. Digite um CNPJ: `00000000000191`
3. Faça algumas consultas
4. Abra o admin: `http://localhost:8081/admin`
5. Veja os dados sendo coletados em tempo real!

---

**📊 100% JavaScript puro, sem backend necessário!**
