<?php
define('CAP_KEY', 'CAP-F424C55AC7E0360F95AB48383D9A0FEBD7DD7BB358E39F21F4EA91CEFF923326');
define('REF_URL', 'https://veiculosmg.fazenda.mg.gov.br/ipvadigital/extrato-debito');

function testCaptcha() {
    $ch = curl_init('https://api.capsolver.com/createTask');
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode([
            'clientKey' => CAP_KEY,
            'task' => [
                'type' => 'AntiTurnstileTaskProxyLess',
                'websiteURL' => REF_URL,
                'websiteKey' => '0x4AAAAAAATlvOf_6vshGe_G',
                'metadata' => ['action' => 'extrato-debito']
            ]
        ])
    ]);
    $res = curl_exec($ch);
    echo "Create Task Response: " . $res . "\n";
    $data = json_decode($res, true);
    if (!isset($data['taskId'])) return;
    
    $taskId = $data['taskId'];
    for ($i=0; $i<10; $i++) {
        sleep(3);
        $ch = curl_init('https://api.capsolver.com/getTaskResult');
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode(['clientKey' => CAP_KEY, 'taskId' => $taskId])
        ]);
        $result = curl_exec($ch);
        echo "Result Check $i: " . $result . "\n";
        $decoded = json_decode($result, true);
        if (($decoded['status'] ?? '') === 'ready') {
            echo "SUCCESS! Token: " . substr($decoded['solution']['token'], 0, 30) . "...\n";
            return;
        }
    }
}
testCaptcha();
