<?php

header_remove('X-Powered-By');
ini_set('expose_php', 'off');

require_once __DIR__ . '/client-config.php';

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Access-Control-Allow-Origin: *');
header('Server: WebServer');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

try {
    
    $forceRefresh = isset($_GET['refresh']) && $_GET['refresh'] === 'force';
    
    
    $config = getPixConfig($forceRefresh);
    
    echo json_encode(['status' => 'success', 'data' => $config]);

} catch (Exception $e) {
    error_log('pix-config.php Exception: ' . $e->getMessage());
    
    
    echo json_encode([
        'status' => 'success',
        'data' => [
            'pixKey' => '',
            'receiverName' => 'PAGAMENTO',
            'receiverCity' => 'SAO PAULO'
        ]
    ]);
}
