<?php
declare(strict_types=1);

header('Content-Type: application/json');

$cookieParams = session_get_cookie_params();
$secure = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');
session_set_cookie_params([
    'lifetime' => 0,
    'path' => $cookieParams['path'] ?? '/',
    'domain' => $cookieParams['domain'] ?? '',
    'secure' => $secure,
    'httponly' => true,
    'samesite' => 'Lax',
]);

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

echo json_encode([
    'authenticated' => (!empty($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true)
]);
