﻿function iniciarPagina() {
    expandirMinimizarTodos();
    MarcarTodosCheckParcelaVeiculo();
}

function expandirMinimizarTodos() {

    var listaDeVeiculos = document.getElementsByName("veiculo");
    elementExpandirMinimizar = document.getElementById("cardIconeExpandir");
    textExpandirMinimizar = document.getElementById("cardTextExpandir");

    for (var j = 0; j < listaDeVeiculos.length; j++) {

        var CodVeiculo = listaDeVeiculos[j].id.substring(listaDeVeiculos[j].id.lastIndexOf('_') + 1);

        var cardVeiculo = document.getElementsByName("cardVeiculo_" + CodVeiculo);
        var cardImposto = document.getElementById("boxImpostos_" + CodVeiculo);



        for (var i = 0; i < cardVeiculo.length; i++) {
            if (elementExpandirMinimizar.className == "fa fa-angle-up") {
                if (cardImposto.className.includes("collapse show")) {
                    cardVeiculo[i].click();
                    cardImposto.className = "box-imposto collapse";
                }
            }
            if (elementExpandirMinimizar.className == "fa fa-angle-down") {
                if (!(cardImposto.className.includes("collapse show"))) {
                    cardVeiculo[i].click();
                    cardImposto.className = "box-imposto collapse show"
                }
            }
        }

    }

    if (elementExpandirMinimizar != null) {
        if (elementExpandirMinimizar.className == "fa fa-angle-up") {
            elementExpandirMinimizar.className = "fa fa-angle-down";
        }
        else {
            elementExpandirMinimizar.className = "fa fa-angle-up"
        }
    }
}

function expandirMinimizar(CodVeiculo) {
    var cardVeiculo = document.getElementsByName("cardVeiculo_" + CodVeiculo);
    var cardImposto = document.getElementById("boxImpostos_" + CodVeiculo);
    elementExpandirMinimizar = document.getElementById("cardIconeExpandir");


    for (var i = 0; i < cardVeiculo.length; i++) {
        if (elementExpandirMinimizar.className == "fa fa-angle-up") {
            if (cardImposto.className.includes("collapse show")) {
                cardVeiculo[i].click();
                cardImposto.className = "box-imposto collapse";
            }
        }
        if (elementExpandirMinimizar.className == "fa fa-angle-down") {
            if (!(cardImposto.className.includes("collapse show"))) {
                cardVeiculo[i].click();
                cardImposto.className = "box-imposto collapse show"
            }
        }
    }

    if (elementExpandirMinimizar.className == "fa fa-angle-up") {
        elementExpandirMinimizar.className = "fa fa-angle-down";
    }
    else {
        elementExpandirMinimizar.className = "fa fa-angle-up"
    }
}

function alterarCheckVeiculoTodos() {
    var checkSelecionarTodos = document.getElementById("SelecionarTodos");

    var listaCardVeiculos = document.getElementsByName("veiculo");

    if (!checkSelecionarTodos.checked) {
        DesmarcaTodosCheckParcelaVeiculo()
    }
    else {
        var listaCardVeiculos = document.getElementsByName("veiculo");

        for (var j = 0; j < listaCardVeiculos.length; j++) {
            var cardVeiculo = listaCardVeiculos[j];
            var CodVeiculo = cardVeiculo.id.substring(cardVeiculo.id.lastIndexOf('_') + 1);


            var checkVeiculo = document.getElementById("checkVeiculo_" + CodVeiculo);
            var listaCardImposto = document.getElementsByName("cardVeiculo_" + CodVeiculo);
            checkVeiculo.checked = true;

            for (var i = 0; i < listaCardImposto.length; i++) {
                var cardImposto = listaCardImposto[i];

                var codImposto = cardImposto.id.substring(cardImposto.id.lastIndexOf('_') + 1);
                var listaCardParcela = document.getElementsByName(cardImposto.id);
                var marcarApenasCotaUnica = false;

                for (var y = 0; y < listaCardParcela.length; y++) {

                    if (listaCardParcela[y].id.includes("Unica")) {
                        var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);
                        var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                        if (!checkParcela.disabled) {
                            marcarApenasCotaUnica = true;
                            break;
                        }
                    }
                }

                for (var y = 0; y < listaCardParcela.length; y++) {

                    var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);

                    if (marcarApenasCotaUnica) {
                        if (listaCardParcela[y].id.includes("Unica")) {
                            var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                            checkParcela.checked = checkVeiculo.checked;
                        }
                        else {
                            var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                            checkParcela.checked = false;
                        }
                    }
                    else {
                        if (listaCardParcela[y].id.includes("Unica")) {
                            var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                            checkParcela.checked = false;
                        }
                        else {
                            var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                            checkParcela.checked = checkVeiculo.checked;
                        }
                    }
                }
            }

        }



        verificarSeApresentaEmissaoDaems();
    }
}

function alterarCheckProximaParcela() {

    var checkSelecionarTodos = document.getElementById("SelecionarTodos");

    var listaCardVeiculos = document.getElementsByName("veiculo");

    checkSelecionarTodos.checked = false;

    DesmarcaTodosCheckParcelaVeiculo();

    var listaCardVeiculos = document.getElementsByName("veiculo");

    for (var j = 0; j < listaCardVeiculos.length; j++) {
        var cardVeiculo = listaCardVeiculos[j];
        var CodVeiculo = cardVeiculo.id.substring(cardVeiculo.id.lastIndexOf('_') + 1);


        var checkVeiculo = document.getElementById("checkVeiculo_" + CodVeiculo);
        var listaCardImposto = document.getElementsByName("cardVeiculo_" + CodVeiculo);
        checkVeiculo.checked = true;

        for (var i = 0; i < listaCardImposto.length; i++) {
            var cardImposto = listaCardImposto[i];

            var codImposto = cardImposto.id.substring(cardImposto.id.lastIndexOf('_') + 1);
            var listaCardParcela = document.getElementsByName(cardImposto.id);

            for (var y = 0; y < listaCardParcela.length; y++) {

                var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);


                if (listaCardParcela[y].id.includes("Unica")) {
                    if (listaCardParcela.length > 1) {
                        continue;
                    }
                    else {
                        var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                        checkParcela.checked = true;
                        break;
                    }
                }
                else {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                    checkParcela.checked = true;
                    break;
                }
            }
        }

    }

    verificarSeApresentaEmissaoDaems();

}

function MarcarTodosCheckParcelaVeiculo() {
    var checkSelecionarTodos = document.getElementById("SelecionarTodos");
    if (checkSelecionarTodos != null) {
        DesmarcaTodosCheckParcelaVeiculo();
        checkSelecionarTodos.checked = true;
        alterarCheckVeiculoTodos();
    }

}

function DesmarcaTodosCheckParcelaVeiculo() {

    var listaCardVeiculos = document.getElementsByName("veiculo");

    for (var j = 0; j < listaCardVeiculos.length; j++) {
        var cardVeiculo = listaCardVeiculos[j];
        var CodVeiculo = cardVeiculo.id.substring(cardVeiculo.id.lastIndexOf('_') + 1);


        var checkVeiculo = document.getElementById("checkVeiculo_" + CodVeiculo);
        var listaCardImposto = document.getElementsByName("cardVeiculo_" + CodVeiculo);
        checkVeiculo.checked = false;

        for (var i = 0; i < listaCardImposto.length; i++) {
            var cardImposto = listaCardImposto[i];

            var codImposto = cardImposto.id.substring(cardImposto.id.lastIndexOf('_') + 1);
            var listaCardParcela = document.getElementsByName(cardImposto.id);


            for (var y = 0; y < listaCardParcela.length; y++) {

                var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);

                if (listaCardParcela[y].id.includes("Unica")) {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                    checkParcela.checked = false;
                }
                else {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                    checkParcela.checked = false;
                }
            }

        }
    }
    verificarSeApresentaEmissaoDaems();
}

function GerarDaemsAVista() {
    DesmarcaTodosCheckParcelaVeiculo();
    document.getElementById("SelecionarTodos").checked = true;
    alterarCheckVeiculoTodos();
    DirecionarResumoPagamentoParcelasSelecionadas();
}

function GerarProximaParcela() {
    DesmarcaTodosCheckParcelaVeiculo();
    alterarCheckProximaParcela();
    DirecionarResumoPagamentoParcelasSelecionadas();
}

function alterarCheckVeiculo(CodVeiculo) {

    var checkVeiculo = document.getElementById("checkVeiculo_" + CodVeiculo);
    var listaCardImposto = document.getElementsByName("cardVeiculo_" + CodVeiculo);


    for (var i = 0; i < listaCardImposto.length; i++) {
        var cardImposto = listaCardImposto[i];

        var codImposto = cardImposto.id.substring(cardImposto.id.lastIndexOf('_') + 1);
        var listaCardParcela = document.getElementsByName(cardImposto.id);
        var marcarApenasCotaUnica = false;

        for (var y = 0; y < listaCardParcela.length; y++) {

            if (listaCardParcela[y].id.includes("Unica")) {
                var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);
                var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                if (!checkParcela.disabled) {
                    marcarApenasCotaUnica = true;
                    break;
                }
            }
        }

        for (var y = 0; y < listaCardParcela.length; y++) {

            var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);

            if (marcarApenasCotaUnica) {
                if (listaCardParcela[y].id.includes("Unica")) {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                    checkParcela.checked = checkVeiculo.checked;
                }
                else {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                    checkParcela.checked = false;
                }
            }
            else {
                if (listaCardParcela[y].id.includes("Unica")) {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                    checkParcela.checked = false;
                }
                else {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                    checkParcela.checked = checkVeiculo.checked;
                }
            }
        }
    }

    verificarSeApresentaEmissaoDaems();
}

function alterarCheckParcelaNormal(idCardVeiculo, idCardImposto, codParcelaAlterar) {

    const CodVeiculo = idCardVeiculo.substring(idCardVeiculo.lastIndexOf('_') + 1);
    const checkVeiculo = document.getElementById("checkVeiculo_" + CodVeiculo);
    if (checkVeiculo.checked) {
        checkVeiculo.checked = false;
    }

    const listaCardParcela = document.getElementsByName(idCardImposto);
    let marcar = true;
    for (let y = 0; y < listaCardParcela.length; y++) {
        let codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);

        if (listaCardParcela[y].id.includes("Unica")) {
            let checkParcela = document.getElementById(idCardImposto + "_checkParcelaUnica_" + codParcela);
            checkParcela.checked = false;
        }
        else {
            if (codParcela == codParcelaAlterar) {
                marcar = false;
            }
            else {
                let checkParcela = document.getElementById(idCardImposto + "_checkParcela_" + codParcela);
                checkParcela.checked = marcar;
            }

        }
    }

    for (let y = 0; y < listaCardParcela.length; y++) {
        let codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);

        if (listaCardParcela[y].id.includes("Unica")) {
            let checkParcela = document.getElementById(idCardImposto + "_checkParcelaUnica_" + codParcela);
            checkParcela.checked = false;
        }
        else {
            if (codParcela == codParcelaAlterar) {
                break;
            }
            else {
                let checkParcela = document.getElementById(idCardImposto + "_checkParcela_" + codParcela);
                checkParcela.checked = true;
            }
        }
    }
    verificarSeApresentaEmissaoDaems();
}

function alterarCheckParcelaUnica(idCardVeiculo, idCardImposto) {

    const CodVeiculo = idCardVeiculo.substring(idCardVeiculo.lastIndexOf('_') + 1);
    const checkVeiculo = document.getElementById("checkVeiculo_" + CodVeiculo);

    if (checkVeiculo.checked) {
        checkVeiculo.checked = false;
    }

    const listaCardParcela = document.getElementsByName(idCardImposto);

    for (let y = 0; y < listaCardParcela.length; y++) {

        let codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);
        if (!listaCardParcela[y].id.includes("Unica")) {
            let checkParcela = document.getElementById(idCardImposto + "_checkParcela_" + codParcela);
            checkParcela.checked = false;
        }
    }
    verificarSeApresentaEmissaoDaems();
}

function verificarSeApresentaEmissaoDaems() {
    const listaVeiculos = document.getElementsByName("veiculo");
    let valorEmissao = 0;
    for (var j = 0; j < listaVeiculos.length; j++) {
        var cardVeiculo = listaVeiculos[j];
        var CodVeiculo = cardVeiculo.id.substring(cardVeiculo.id.lastIndexOf('_') + 1);
        var listaCardImposto = document.getElementsByName("cardVeiculo_" + CodVeiculo);

        for (var i = 0; i < listaCardImposto.length; i++) {
            var cardImposto = listaCardImposto[i];

            var codImposto = cardImposto.id.substring(cardImposto.id.lastIndexOf('_') + 1);
            var listaCardParcela = document.getElementsByName(cardImposto.id);


            for (var y = 0; y < listaCardParcela.length; y++) {

                var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);
                var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                if (checkParcela != null) {
                    if (checkParcela.checked) {
                        valorEmissao += formatarVirgulaParaPonto(checkParcela.value);
                    }
                }
                else {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                    if (checkParcela != null) {
                        if (checkParcela.checked) {
                            valorEmissao += formatarVirgulaParaPonto(checkParcela.value);
                        }
                    }
                }

            }
        }
    }

    document.getElementById("cardEmitirDaemsValor").innerText = formatarNumeroParaValorMonetario(valorEmissao);
    if (document.getElementById("cardEmitirDaemsValor2") != null) {
        document.getElementById("cardEmitirDaemsValor2").innerText = formatarNumeroParaValorMonetario(valorEmissao);

    }
    if (valorEmissao > 0) {
        document.getElementById("cardEmitirDaems").style.display = "flex";
        document.getElementById("BTNResumoPagamentoParcelasSelecionadas").onclick = function () {
            VerificarSeTemParcelaSelecionadaEDirecionarResumoPagamentoParcelasSelecionadas();
        };
        document.getElementById("BTNResumoPagamentoParcelasSelecionadas2").onclick = function () {
            VerificarSeTemParcelaSelecionadaEDirecionarResumoPagamentoParcelasSelecionadas();
        };
    }
    else {
        document.getElementById("cardEmitirDaems").style.display = "none";
    }
}

function VerificarSeTemParcelaSelecionadaEDirecionarResumoPagamentoParcelasSelecionadas() {
    const listaVeiculos = document.getElementsByName("veiculo");
    let emitir = false;

    for (var j = 0; j < listaVeiculos.length; j++) {
        var cardVeiculo = listaVeiculos[j];
        var CodVeiculo = cardVeiculo.id.substring(cardVeiculo.id.lastIndexOf('_') + 1);
        var listaCardImposto = document.getElementsByName("cardVeiculo_" + CodVeiculo);
        if (emitir == true) {
            break;
        }

        for (var i = 0; i < listaCardImposto.length; i++) {
            var cardImposto = listaCardImposto[i];

            var codImposto = cardImposto.id.substring(cardImposto.id.lastIndexOf('_') + 1);
            var listaCardParcela = document.getElementsByName(cardImposto.id);

            if (emitir == true) {
                break;
            }
            for (var y = 0; y < listaCardParcela.length; y++) {

                var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);
                var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                if (checkParcela != null) {
                    if (checkParcela.checked) {
                        emitir = true;
                        break;
                    }
                }
                else {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                    if (checkParcela != null) {
                        if (checkParcela.checked) {
                            emitir = true;
                            break;
                        }
                    }
                }

            }
        }
    }

    if (emitir == true) {
        DirecionarResumoPagamentoParcelasSelecionadas();
    }
    else {
        alert('Selecione ao menos uma parcela para pagamento!')
    }
}

function DirecionarResumoPagamentoParcelasSelecionadas() {

    var listaObjetos = [];

    const listaVeiculos = document.getElementsByName("veiculo");
    let valorEmissao = 0;

    for (var j = 0; j < listaVeiculos.length; j++) {
        var cardVeiculo = listaVeiculos[j];
        var CodVeiculo = cardVeiculo.id.substring(cardVeiculo.id.lastIndexOf('_') + 1);
        var listaCardImposto = document.getElementsByName("cardVeiculo_" + CodVeiculo);

        for (var i = 0; i < listaCardImposto.length; i++) {
            var cardImposto = listaCardImposto[i];

            var codImposto = cardImposto.id.substring(cardImposto.id.lastIndexOf('_') + 1);
            var listaCardParcela = document.getElementsByName(cardImposto.id);


            for (var y = 0; y < listaCardParcela.length; y++) {

                var codParcela = listaCardParcela[y].id.substring(listaCardParcela[y].id.lastIndexOf('_') + 1);
                var checkParcela = document.getElementById(cardImposto.id + "_checkParcelaUnica_" + codParcela);
                if (checkParcela != null) {
                    if (checkParcela.checked) {
                        listaObjetos.push(codParcela);
                    }
                }
                else {
                    var checkParcela = document.getElementById(cardImposto.id + "_checkParcela_" + codParcela);
                    if (checkParcela != null) {
                        if (checkParcela.checked) {
                            listaObjetos.push(codParcela);
                        }
                    }
                }

            }
        }
    }
    var jsonData = JSON.stringify(listaObjetos);

    irParaResumoPagamento(jsonData)
}

function irParaResumoPagamento(jsonData) {

    $.ajax({
        async: true,
        type: "POST",
        url: content + "Home/MontarResumoPagamento",
        data: {
            jsonListaParcela: jsonData
        },
        success: function (data) {
            if (data.mensagem == "OK") {
                window.location.href = content + "Home/ResumoPagamento";
                return;
            } else {
                alert('ERRO!')
            }

        }
    })
}

function formatarVirgulaParaPonto(valor) {

    if (valor != null) {

        if (valor.indexOf('.') + 1 == valor.length - 2) {
            return parseFloat(valor);
        }
        else if (valor.indexOf(',') + 1 == valor.length - 2) {
            valor = valor.replace('.', '').toString();
            valor = valor.replace(',', '.').toString();

        }
        else {
            valor = valor.replace('.', '').toString();
            valor = valor.replace(',', '').toString();
            valor.includes('.', valor.length - 2);
        }

        return parseFloat(valor);

    }

    return 0.00;

}

function formatarNumeroParaValorMonetario(numero) {

    if (numero != 0) {
        let separadorMilhares = '.';
        let separadorDecimal = ',';
        let numeroArredondado = parseFloat(numero.toFixed(2));
        let numeroString = numeroArredondado.toString();
        let partes = numeroString.split('.');


        partes[0] = partes[0].replace(/\B(?=(\d{3})+(?!\d))/g, separadorMilhares).toString();

        if (partes[1] != null) {
            partes[1] = partes[1].replace(/\B(?=(\d{3})+(?!\d))/g, separadorMilhares).toString();
        }
        else {
            partes[1] = "00";
        }

        if (partes[1].length == 0) {
            partes[1] = "00";
        }
        else if (partes[1].length == 1) {
            partes[1] = partes[1] + "0";
        }

        let numeroFormatado = partes.join(separadorDecimal).toString();



        return 'R$ ' + numeroFormatado.toString();
    }

    return 'R$ 0,00';

}

function apresentaCardToolTip(cardToolTipValorParcela) {
    cardToolTipValorParcela.style.display = "flex";

}

function esconderCardToolTip(cardToolTipValorParcela) {
    cardToolTipValorParcela.style.display = "none";

}