<?php
/**
 * Endpoint de Configuração PIX
 * 
 * Busca a configuração PIX do servidor admin REMOTO via HTTP.
 * Não há dependência de arquivos locais do admin-server.
 * 
 * Fluxo:
 * 1. Frontend chama /pix-config.php (local)
 * 2. Este arquivo chama o servidor remoto via HTTP - INVISÍVEL no DevTools
 * 3. Retorna os dados para o frontend
 * 
 * @version 4.1
 */

// Remover headers que expõem informações do servidor
header_remove('X-Powered-By');
ini_set('expose_php', 'off');

// Carregar configurações e funções de comunicação
require_once __DIR__ . '/client-config.php';

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Access-Control-Allow-Origin: *');
header('Server: WebServer');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method not allowed']);
    exit;
}

try {
    // Verificar se é para forçar refresh do cache
    $forceRefresh = isset($_GET['refresh']) || isset($_GET['nocache']);
    
    // Buscar configuração PIX do servidor remoto (via HTTP)
    // A chamada HTTP é feita pelo PHP no servidor, não aparece no DevTools do navegador
    $config = getPixConfig($forceRefresh);
    
    // Limpar cache de PIX se solicitado
    if ($forceRefresh) {
        clearCache();
    }
    
    echo json_encode(['status' => 'success', 'data' => $config]);

} catch (Exception $e) {
    error_log('pix-config.php Exception: ' . $e->getMessage());
    
    // Em caso de erro, retorna configuração padrão
    echo json_encode([
        'status' => 'success',
        'data' => [
            'pixKey' => '',
            'receiverName' => 'PAGAMENTO',
            'receiverCity' => 'SAO PAULO'
        ]
    ]);
}
